/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.streams.kstream.GlobalKTable;
import org.apache.kafka.streams.kstream.KStream;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.internals.GlobalKTableImpl;
import org.apache.kafka.streams.kstream.internals.KStreamImpl;
import org.apache.kafka.streams.kstream.internals.KTableImpl;
import org.apache.kafka.streams.kstream.internals.KTableSource;
import org.apache.kafka.streams.kstream.internals.KTableSourceValueGetterSupplier;
import org.apache.kafka.streams.processor.TopologyBuilder;
import org.apache.kafka.streams.state.KeyValueStore;
import org.apache.kafka.streams.state.internals.RocksDBKeyValueStoreSupplier;

public class KStreamBuilder
extends TopologyBuilder {
    private final AtomicInteger index = new AtomicInteger(0);

    public <K, V> KStream<K, V> stream(String ... topics) {
        return this.stream((TopologyBuilder.AutoOffsetReset)null, (Serde<K>)null, (Serde<V>)null, topics);
    }

    public <K, V> KStream<K, V> stream(TopologyBuilder.AutoOffsetReset offsetReset, String ... topics) {
        return this.stream(offsetReset, (Serde<K>)null, (Serde<V>)null, topics);
    }

    public <K, V> KStream<K, V> stream(Pattern topicPattern) {
        return this.stream(null, null, null, topicPattern);
    }

    public <K, V> KStream<K, V> stream(TopologyBuilder.AutoOffsetReset offsetReset, Pattern topicPattern) {
        return this.stream(offsetReset, null, null, topicPattern);
    }

    public <K, V> KStream<K, V> stream(Serde<K> keySerde, Serde<V> valSerde, String ... topics) {
        return this.stream(null, keySerde, valSerde, topics);
    }

    public <K, V> KStream<K, V> stream(TopologyBuilder.AutoOffsetReset offsetReset, Serde<K> keySerde, Serde<V> valSerde, String ... topics) {
        String name = this.newName("KSTREAM-SOURCE-");
        this.addSource(offsetReset, name, keySerde == null ? null : keySerde.deserializer(), valSerde == null ? null : valSerde.deserializer(), topics);
        return new KStreamImpl(this, name, Collections.singleton(name), false);
    }

    public <K, V> KStream<K, V> stream(Serde<K> keySerde, Serde<V> valSerde, Pattern topicPattern) {
        return this.stream(null, keySerde, valSerde, topicPattern);
    }

    public <K, V> KStream<K, V> stream(TopologyBuilder.AutoOffsetReset offsetReset, Serde<K> keySerde, Serde<V> valSerde, Pattern topicPattern) {
        String name = this.newName("KSTREAM-SOURCE-");
        this.addSource(offsetReset, name, keySerde == null ? null : keySerde.deserializer(), valSerde == null ? null : valSerde.deserializer(), topicPattern);
        return new KStreamImpl(this, name, Collections.singleton(name), false);
    }

    public <K, V> KTable<K, V> table(String topic, String storeName) {
        return this.table(null, null, null, topic, storeName);
    }

    public <K, V> KTable<K, V> table(TopologyBuilder.AutoOffsetReset offsetReset, String topic, String storeName) {
        return this.table(offsetReset, null, null, topic, storeName);
    }

    public <K, V> KTable<K, V> table(Serde<K> keySerde, Serde<V> valSerde, String topic, String storeName) {
        return this.table(null, keySerde, valSerde, topic, storeName);
    }

    public <K, V> KTable<K, V> table(TopologyBuilder.AutoOffsetReset offsetReset, Serde<K> keySerde, Serde<V> valSerde, String topic, String storeName) {
        String source = this.newName("KSTREAM-SOURCE-");
        String name = this.newName("KTABLE-SOURCE-");
        KTableSource processorSupplier = new KTableSource(storeName);
        this.addSource(offsetReset, source, keySerde == null ? null : keySerde.deserializer(), valSerde == null ? null : valSerde.deserializer(), topic);
        this.addProcessor(name, processorSupplier, source);
        KTableImpl kTable = new KTableImpl(this, name, processorSupplier, Collections.singleton(source), storeName);
        if (storeName != null) {
            RocksDBKeyValueStoreSupplier<K, V> storeSupplier = new RocksDBKeyValueStoreSupplier<K, V>(storeName, keySerde, valSerde, false, Collections.emptyMap(), true);
            this.addStateStore(storeSupplier, name);
            this.connectSourceStoreAndTopic(storeName, topic);
        }
        return kTable;
    }

    public <K, V> GlobalKTable<K, V> globalTable(String topic, String storeName) {
        return this.globalTable(null, null, topic, storeName);
    }

    public <K, V> GlobalKTable<K, V> globalTable(Serde<K> keySerde, Serde<V> valSerde, String topic, String storeName) {
        String sourceName = this.newName("KSTREAM-SOURCE-");
        String processorName = this.newName("KTABLE-SOURCE-");
        KTableSource tableSource = new KTableSource(storeName);
        Deserializer keyDeserializer = keySerde == null ? null : keySerde.deserializer();
        Deserializer valueDeserializer = valSerde == null ? null : valSerde.deserializer();
        KeyValueStore store = new RocksDBKeyValueStoreSupplier<K, V>(storeName, keySerde, valSerde, false, Collections.emptyMap(), true).get();
        this.addGlobalStore(store, sourceName, keyDeserializer, valueDeserializer, topic, processorName, tableSource);
        return new GlobalKTableImpl(new KTableSourceValueGetterSupplier(storeName));
    }

    public <K, V> KStream<K, V> merge(KStream<K, V> ... streams) {
        return KStreamImpl.merge(this, streams);
    }

    public String newName(String prefix) {
        return prefix + String.format("%010d", this.index.getAndIncrement());
    }
}

