/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.PriorityQueue;
import org.apache.kafka.streams.processor.internals.PunctuationSchedule;
import org.apache.kafka.streams.processor.internals.Punctuator;

public class PunctuationQueue {
    private final PriorityQueue<PunctuationSchedule> pq = new PriorityQueue();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void schedule(PunctuationSchedule sched) {
        PriorityQueue<PunctuationSchedule> priorityQueue = this.pq;
        synchronized (priorityQueue) {
            this.pq.add(sched);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        PriorityQueue<PunctuationSchedule> priorityQueue = this.pq;
        synchronized (priorityQueue) {
            this.pq.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mayPunctuate(long timestamp, Punctuator punctuator) {
        PriorityQueue<PunctuationSchedule> priorityQueue = this.pq;
        synchronized (priorityQueue) {
            boolean punctuated = false;
            PunctuationSchedule top = this.pq.peek();
            while (top != null && top.timestamp <= timestamp) {
                PunctuationSchedule sched = top;
                this.pq.poll();
                punctuator.punctuate(sched.node(), timestamp);
                this.pq.add(sched.next(timestamp));
                punctuated = true;
                top = this.pq.peek();
            }
            return punctuated;
        }
    }
}

