/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.List;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.streams.kstream.internals.ChangedDeserializer;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.internals.ProcessorNode;

public class SourceNode<K, V>
extends ProcessorNode<K, V> {
    private final List<String> topics;
    private ProcessorContext context;
    private Deserializer<K> keyDeserializer;
    private Deserializer<V> valDeserializer;

    public SourceNode(String name, List<String> topics, Deserializer<K> keyDeserializer, Deserializer<V> valDeserializer) {
        super(name);
        this.topics = topics;
        this.keyDeserializer = keyDeserializer;
        this.valDeserializer = valDeserializer;
    }

    K deserializeKey(String topic, byte[] data) {
        return (K)this.keyDeserializer.deserialize(topic, data);
    }

    V deserializeValue(String topic, byte[] data) {
        return (V)this.valDeserializer.deserialize(topic, data);
    }

    @Override
    public void init(ProcessorContext context) {
        super.init(context);
        this.context = context;
        if (this.keyDeserializer == null) {
            this.keyDeserializer = context.keySerde().deserializer();
        }
        if (this.valDeserializer == null) {
            this.valDeserializer = context.valueSerde().deserializer();
        }
        if (this.valDeserializer instanceof ChangedDeserializer && ((ChangedDeserializer)this.valDeserializer).inner() == null) {
            ((ChangedDeserializer)this.valDeserializer).setInner(context.valueSerde().deserializer());
        }
    }

    @Override
    public void process(K key, V value) {
        this.context.forward(key, value);
        this.nodeMetrics.sourceNodeForwardSensor.record();
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String indent) {
        StringBuilder sb = new StringBuilder(super.toString(indent));
        sb.append(indent).append("\ttopics:\t\t[");
        for (String topic : this.topics) {
            sb.append(topic);
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("]\n");
        return sb.toString();
    }
}

