/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.AbstractTask;
import org.apache.kafka.streams.processor.internals.PartitionGroup;
import org.apache.kafka.streams.processor.internals.ProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.ProcessorNode;
import org.apache.kafka.streams.processor.internals.ProcessorRecordContext;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.PunctuationQueue;
import org.apache.kafka.streams.processor.internals.PunctuationSchedule;
import org.apache.kafka.streams.processor.internals.Punctuator;
import org.apache.kafka.streams.processor.internals.RecordCollector;
import org.apache.kafka.streams.processor.internals.RecordQueue;
import org.apache.kafka.streams.processor.internals.SourceNode;
import org.apache.kafka.streams.processor.internals.StampedRecord;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTask
extends AbstractTask
implements Punctuator {
    private static final Logger log = LoggerFactory.getLogger(StreamTask.class);
    private static final ConsumerRecord<Object, Object> DUMMY_RECORD = new ConsumerRecord("__null_topic__", -1, -1L, null, null);
    private final String logPrefix;
    private final PartitionGroup partitionGroup;
    private final PartitionGroup.RecordInfo recordInfo = new PartitionGroup.RecordInfo();
    private final PunctuationQueue punctuationQueue;
    private final Map<TopicPartition, RecordQueue> partitionQueues;
    private final Map<TopicPartition, Long> consumedOffsets;
    private final RecordCollector recordCollector;
    private final int maxBufferedSize;
    private boolean commitRequested = false;
    private boolean commitOffsetNeeded = false;
    private boolean requiresPoll = true;
    private final Time time;
    private final TaskMetrics metrics;
    private Runnable commitDelegate = new Runnable(){

        @Override
        public void run() {
            log.debug("{} Committing its state", (Object)StreamTask.this.logPrefix);
            StreamTask.this.stateMgr.flush(StreamTask.this.processorContext);
            log.trace("{} Start flushing its producer's sent records upon committing its state", (Object)StreamTask.this.logPrefix);
            StreamTask.this.recordCollector.flush();
            StreamTask.this.commitOffsets();
        }
    };

    public StreamTask(TaskId id, String applicationId, Collection<TopicPartition> partitions, ProcessorTopology topology, Consumer<byte[], byte[]> consumer, Consumer<byte[], byte[]> restoreConsumer, StreamsConfig config, StreamsMetrics metrics, StateDirectory stateDirectory, ThreadCache cache, Time time, RecordCollector recordCollector) {
        super(id, applicationId, partitions, topology, consumer, restoreConsumer, false, stateDirectory, cache);
        this.punctuationQueue = new PunctuationQueue();
        this.maxBufferedSize = config.getInt("buffered.records.per.partition");
        this.metrics = new TaskMetrics(metrics);
        this.partitionQueues = new HashMap<TopicPartition, RecordQueue>();
        TimestampExtractor timestampExtractor = (TimestampExtractor)config.getConfiguredInstance("timestamp.extractor", TimestampExtractor.class);
        for (TopicPartition partition : partitions) {
            SourceNode source = topology.source(partition.topic());
            RecordQueue queue = this.createRecordQueue(partition, source, timestampExtractor);
            this.partitionQueues.put(partition, queue);
        }
        this.logPrefix = String.format("task [%s]", id);
        this.partitionGroup = new PartitionGroup(this.partitionQueues, timestampExtractor);
        this.consumedOffsets = new HashMap<TopicPartition, Long>();
        this.recordCollector = recordCollector;
        this.processorContext = new ProcessorContextImpl(id, this, config, this.recordCollector, this.stateMgr, metrics, cache);
        this.time = time;
        log.info("{} Initializing state stores", (Object)this.logPrefix);
        this.initializeStateStores();
        this.stateMgr.registerGlobalStateStores(topology.globalStateStores());
        this.initTopology();
        this.processorContext.initialized();
    }

    public int addRecords(TopicPartition partition, Iterable<ConsumerRecord<byte[], byte[]>> records) {
        int oldQueueSize = this.partitionGroup.numBuffered();
        int newQueueSize = this.partitionGroup.addRawRecords(partition, records);
        log.trace("{} Added records into the buffered queue of partition {}, new queue size is {}", new Object[]{this.logPrefix, partition, newQueueSize});
        if (newQueueSize > this.maxBufferedSize) {
            this.consumer.pause(Collections.singleton(partition));
        }
        return newQueueSize - oldQueueSize;
    }

    public int process() {
        StampedRecord record = this.partitionGroup.nextRecord(this.recordInfo);
        if (record == null) {
            this.requiresPoll = true;
            return 0;
        }
        this.requiresPoll = false;
        try {
            ProcessorNode currNode = this.recordInfo.node();
            TopicPartition partition = this.recordInfo.partition();
            log.trace("{} Start processing one record [{}]", (Object)this.logPrefix, (Object)record);
            ProcessorRecordContext recordContext = this.createRecordContext(record);
            this.updateProcessorContext(recordContext, currNode);
            currNode.process(record.key(), record.value());
            log.trace("{} Completed processing one record [{}]", (Object)this.logPrefix, (Object)record);
            this.consumedOffsets.put(partition, record.offset());
            this.commitOffsetNeeded = true;
            if (this.recordInfo.queue().size() == this.maxBufferedSize) {
                this.consumer.resume(Collections.singleton(partition));
                this.requiresPoll = true;
            }
            if (this.partitionGroup.topQueueSize() <= this.maxBufferedSize) {
                this.requiresPoll = true;
            }
        }
        catch (KafkaException ke) {
            throw new StreamsException(String.format("Exception caught in process. taskId=%s, processor=%s, topic=%s, partition=%d, offset=%d", this.id.toString(), this.processorContext.currentNode().name(), record.topic(), record.partition(), record.offset()), ke);
        }
        finally {
            this.processorContext.setCurrentNode(null);
        }
        return this.partitionGroup.numBuffered();
    }

    private void updateProcessorContext(ProcessorRecordContext recordContext, ProcessorNode currNode) {
        this.processorContext.setRecordContext(recordContext);
        this.processorContext.setCurrentNode(currNode);
    }

    public boolean requiresPoll() {
        return this.requiresPoll;
    }

    public boolean maybePunctuate() {
        long timestamp = this.partitionGroup.timestamp();
        if (timestamp == -1L) {
            return false;
        }
        return this.punctuationQueue.mayPunctuate(timestamp, this);
    }

    @Override
    public void punctuate(ProcessorNode node, long timestamp) {
        if (this.processorContext.currentNode() != null) {
            throw new IllegalStateException(String.format("%s Current node is not null", this.logPrefix));
        }
        StampedRecord stampedRecord = new StampedRecord(DUMMY_RECORD, timestamp);
        this.updateProcessorContext(this.createRecordContext(stampedRecord), node);
        log.trace("{} Punctuating processor {} with timestamp {}", new Object[]{this.logPrefix, node.name(), timestamp});
        try {
            node.punctuate(timestamp);
        }
        catch (KafkaException ke) {
            throw new StreamsException(String.format("Exception caught in punctuate. taskId=%s processor=%s", this.id, node.name()), ke);
        }
        finally {
            this.processorContext.setCurrentNode(null);
        }
    }

    @Override
    public void commit() {
        this.metrics.metrics.measureLatencyNs(this.time, this.commitDelegate, this.metrics.taskCommitTimeSensor);
    }

    @Override
    public void commitOffsets() {
        if (this.commitOffsetNeeded) {
            HashMap<TopicPartition, OffsetAndMetadata> consumedOffsetsAndMetadata = new HashMap<TopicPartition, OffsetAndMetadata>(this.consumedOffsets.size());
            for (Map.Entry<TopicPartition, Long> entry : this.consumedOffsets.entrySet()) {
                TopicPartition partition = entry.getKey();
                long offset = entry.getValue() + 1L;
                consumedOffsetsAndMetadata.put(partition, new OffsetAndMetadata(offset));
                this.stateMgr.putOffsetLimit(partition, offset);
            }
            this.consumer.commitSync(consumedOffsetsAndMetadata);
            this.commitOffsetNeeded = false;
        }
        this.commitRequested = false;
    }

    public boolean commitNeeded() {
        return this.commitRequested;
    }

    public void needCommit() {
        this.commitRequested = true;
    }

    public void schedule(long interval) {
        if (this.processorContext.currentNode() == null) {
            throw new IllegalStateException(String.format("%s Current node is null", this.logPrefix));
        }
        this.punctuationQueue.schedule(new PunctuationSchedule(this.processorContext.currentNode(), interval));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initTopology() {
        log.info("{} Initializing processor nodes of the topology", (Object)this.logPrefix);
        for (ProcessorNode node : this.topology.processors()) {
            this.processorContext.setCurrentNode(node);
            try {
                node.init(this.processorContext);
            }
            finally {
                this.processorContext.setCurrentNode(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeTopology() {
        this.partitionGroup.clear();
        RuntimeException exception = null;
        for (ProcessorNode node : this.topology.processors()) {
            this.processorContext.setCurrentNode(node);
            try {
                node.close();
            }
            catch (RuntimeException e) {
                exception = e;
            }
            finally {
                this.processorContext.setCurrentNode(null);
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    @Override
    public void close() {
        log.debug("{} Closing processor topology", (Object)this.logPrefix);
        this.partitionGroup.close();
        this.closeTopology();
        this.metrics.removeAllSensors();
    }

    @Override
    protected Map<TopicPartition, Long> recordCollectorOffsets() {
        return this.recordCollector.offsets();
    }

    private RecordQueue createRecordQueue(TopicPartition partition, SourceNode source, TimestampExtractor timestampExtractor) {
        return new RecordQueue(partition, source, timestampExtractor);
    }

    private ProcessorRecordContext createRecordContext(StampedRecord currRecord) {
        return new ProcessorRecordContext(currRecord.timestamp, currRecord.offset(), currRecord.partition(), currRecord.topic());
    }

    @Override
    public String toString() {
        return super.toString();
    }

    @Override
    public void flushState() {
        super.flushState();
        this.recordCollector.flush();
    }

    protected class TaskMetrics {
        final StreamsMetricsImpl metrics;
        final Sensor taskCommitTimeSensor;

        public TaskMetrics(StreamsMetrics metrics) {
            String name = StreamTask.this.id.toString();
            this.metrics = (StreamsMetricsImpl)metrics;
            this.taskCommitTimeSensor = metrics.addLatencyAndThroughputSensor("task", name, "commit", Sensor.RecordingLevel.DEBUG, "streams-task-id", name);
        }

        public void removeAllSensors() {
            this.metrics.removeSensor(this.taskCommitTimeSensor);
        }
    }
}

