/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.CommitFailedException;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Count;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.SampledStat;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KafkaClientSupplier;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.LockException;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.errors.TaskIdFormatException;
import org.apache.kafka.streams.processor.PartitionGrouper;
import org.apache.kafka.streams.processor.TaskId;
import org.apache.kafka.streams.processor.TopologyBuilder;
import org.apache.kafka.streams.processor.internals.AbstractTask;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.RecordCollectorImpl;
import org.apache.kafka.streams.processor.internals.StandbyTask;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamPartitionAssignor;
import org.apache.kafka.streams.processor.internals.StreamTask;
import org.apache.kafka.streams.processor.internals.StreamsMetadataState;
import org.apache.kafka.streams.processor.internals.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamThread
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(StreamThread.class);
    private static final AtomicInteger STREAM_THREAD_ID_SEQUENCE = new AtomicInteger(1);
    private volatile State state = State.NOT_RUNNING;
    private StateListener stateListener = null;
    public final PartitionGrouper partitionGrouper;
    private final StreamsMetadataState streamsMetadataState;
    public final String applicationId;
    public final String clientId;
    public final UUID processId;
    protected final StreamsConfig config;
    protected final TopologyBuilder builder;
    protected final Producer<byte[], byte[]> producer;
    protected final Consumer<byte[], byte[]> consumer;
    protected final Consumer<byte[], byte[]> restoreConsumer;
    private final String logPrefix;
    private final String threadClientId;
    private final Pattern sourceTopicPattern;
    private final Map<TaskId, StreamTask> activeTasks;
    private final Map<TaskId, StandbyTask> standbyTasks;
    private final Map<TopicPartition, StreamTask> activeTasksByPartition;
    private final Map<TopicPartition, StandbyTask> standbyTasksByPartition;
    private final Set<TaskId> prevTasks;
    private final Map<TaskId, StreamTask> suspendedTasks;
    private final Map<TaskId, StandbyTask> suspendedStandbyTasks;
    private final Time time;
    private final long pollTimeMs;
    private final long cleanTimeMs;
    private final long commitTimeMs;
    private final StreamsMetricsThreadImpl streamsMetrics;
    final StateDirectory stateDirectory;
    private String originalReset;
    private StreamPartitionAssignor partitionAssignor = null;
    private boolean cleanRun = false;
    private long timerStartedMs;
    private long lastCleanMs;
    private long lastCommitMs;
    private Throwable rebalanceException = null;
    private Map<TopicPartition, List<ConsumerRecord<byte[], byte[]>>> standbyRecords;
    private boolean processStandbyRecords = false;
    private ThreadCache cache;
    private final TaskCreator taskCreator = new TaskCreator();
    final ConsumerRebalanceListener rebalanceListener = new ConsumerRebalanceListener(){

        public void onPartitionsAssigned(Collection<TopicPartition> assignment) {
            try {
                if (StreamThread.this.state == State.PENDING_SHUTDOWN) {
                    log.info("stream-thread [{}] New partitions [{}] assigned while shutting down.", (Object)StreamThread.this.getName(), assignment);
                }
                log.info("stream-thread [{}] New partitions [{}] assigned at the end of consumer rebalance.", (Object)StreamThread.this.getName(), assignment);
                StreamThread.this.setStateWhenNotInPendingShutdown(State.ASSIGNING_PARTITIONS);
                StreamThread.this.closeNonAssignedSuspendedStandbyTasks();
                StreamThread.this.closeNonAssignedSuspendedTasks();
                StreamThread.this.addStreamTasks(assignment);
                StreamThread.this.addStandbyTasks();
                StreamThread.this.lastCleanMs = StreamThread.this.time.milliseconds();
                StreamThread.this.streamsMetadataState.onChange(StreamThread.this.partitionAssignor.getPartitionsByHostState(), StreamThread.this.partitionAssignor.clusterMetadata());
                StreamThread.this.setStateWhenNotInPendingShutdown(State.RUNNING);
            }
            catch (Throwable t) {
                StreamThread.this.rebalanceException = t;
                throw t;
            }
        }

        public void onPartitionsRevoked(Collection<TopicPartition> assignment) {
            try {
                if (StreamThread.this.state == State.PENDING_SHUTDOWN) {
                    log.info("stream-thread [{}] New partitions [{}] revoked while shutting down.", (Object)StreamThread.this.getName(), assignment);
                }
                log.info("stream-thread [{}] partitions [{}] revoked at the beginning of consumer rebalance.", (Object)StreamThread.this.getName(), assignment);
                StreamThread.this.setStateWhenNotInPendingShutdown(State.PARTITIONS_REVOKED);
                StreamThread.this.lastCleanMs = Long.MAX_VALUE;
                StreamThread.this.suspendTasksAndState();
            }
            catch (Throwable t) {
                StreamThread.this.rebalanceException = t;
                throw t;
            }
            finally {
                StreamThread.this.streamsMetadataState.onChange(Collections.emptyMap(), StreamThread.this.partitionAssignor.clusterMetadata());
                StreamThread.this.removeStreamTasks();
                StreamThread.this.removeStandbyTasks();
            }
        }
    };

    public void setStateListener(StateListener listener) {
        this.stateListener = listener;
    }

    public synchronized State state() {
        return this.state;
    }

    private synchronized void setState(State newState) {
        State oldState = this.state;
        if (!this.state.isValidTransition(newState)) {
            log.warn("Unexpected state transition from " + (Object)((Object)this.state) + " to " + (Object)((Object)newState));
        }
        this.state = newState;
        if (this.stateListener != null) {
            this.stateListener.onChange(this, this.state, oldState);
        }
    }

    private synchronized void setStateWhenNotInPendingShutdown(State newState) {
        if (this.state == State.PENDING_SHUTDOWN) {
            return;
        }
        this.setState(newState);
    }

    public synchronized boolean isInitialized() {
        return this.state == State.RUNNING;
    }

    public String threadClientId() {
        return this.threadClientId;
    }

    public StreamThread(TopologyBuilder builder, StreamsConfig config, KafkaClientSupplier clientSupplier, String applicationId, String clientId, UUID processId, Metrics metrics, Time time, StreamsMetadataState streamsMetadataState, long cacheSizeBytes) {
        super("StreamThread-" + STREAM_THREAD_ID_SEQUENCE.getAndIncrement());
        this.applicationId = applicationId;
        String threadName = this.getName();
        this.config = config;
        this.builder = builder;
        this.sourceTopicPattern = builder.sourceTopicPattern();
        this.clientId = clientId;
        this.processId = processId;
        this.partitionGrouper = (PartitionGrouper)config.getConfiguredInstance("partition.grouper", PartitionGrouper.class);
        this.streamsMetadataState = streamsMetadataState;
        this.threadClientId = clientId + "-" + threadName;
        this.streamsMetrics = new StreamsMetricsThreadImpl(metrics, "stream-metrics", "thread." + this.threadClientId, Collections.singletonMap("client-id", this.threadClientId));
        if (config.getLong("cache.max.bytes.buffering") < 0L) {
            log.warn("Negative cache size passed in thread [{}]. Reverting to cache size of 0 bytes.", (Object)threadName);
        }
        this.cache = new ThreadCache(this.threadClientId, cacheSizeBytes, this.streamsMetrics);
        this.logPrefix = String.format("stream-thread [%s]", threadName);
        log.info("{} Creating producer client", (Object)this.logPrefix);
        this.producer = clientSupplier.getProducer(config.getProducerConfigs(this.threadClientId));
        log.info("{} Creating consumer client", (Object)this.logPrefix);
        Map<String, Object> consumerConfigs = config.getConsumerConfigs(this, applicationId, this.threadClientId);
        if (!builder.latestResetTopicsPattern().pattern().equals("") || !builder.earliestResetTopicsPattern().pattern().equals("")) {
            this.originalReset = (String)consumerConfigs.get("auto.offset.reset");
            log.info("{} custom offset resets specified updating configs original auto offset reset {}", (Object)this.logPrefix, (Object)this.originalReset);
            consumerConfigs.put("auto.offset.reset", "none");
        }
        this.consumer = clientSupplier.getConsumer(consumerConfigs);
        log.info("{} Creating restore consumer client", (Object)this.logPrefix);
        this.restoreConsumer = clientSupplier.getRestoreConsumer(config.getRestoreConsumerConfigs(this.threadClientId));
        this.activeTasks = new ConcurrentHashMap<TaskId, StreamTask>();
        this.standbyTasks = new HashMap<TaskId, StandbyTask>();
        this.activeTasksByPartition = new HashMap<TopicPartition, StreamTask>();
        this.standbyTasksByPartition = new HashMap<TopicPartition, StandbyTask>();
        this.prevTasks = new HashSet<TaskId>();
        this.suspendedTasks = new HashMap<TaskId, StreamTask>();
        this.suspendedStandbyTasks = new HashMap<TaskId, StandbyTask>();
        this.standbyRecords = new HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>>();
        this.stateDirectory = new StateDirectory(applicationId, config.getString("state.dir"));
        this.pollTimeMs = config.getLong("poll.ms");
        this.commitTimeMs = config.getLong("commit.interval.ms");
        this.cleanTimeMs = config.getLong("state.cleanup.delay.ms");
        this.time = time;
        this.timerStartedMs = time.milliseconds();
        this.lastCleanMs = Long.MAX_VALUE;
        this.lastCommitMs = this.timerStartedMs;
        this.setState(State.RUNNING);
    }

    public void partitionAssignor(StreamPartitionAssignor partitionAssignor) {
        this.partitionAssignor = partitionAssignor;
    }

    @Override
    public void run() {
        log.info("{} Starting", (Object)this.logPrefix);
        try {
            this.runLoop();
            this.cleanRun = true;
        }
        catch (KafkaException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("{} Streams application error during processing: ", (Object)this.logPrefix, (Object)e);
            throw e;
        }
        finally {
            this.shutdown();
        }
    }

    public synchronized void close() {
        log.info("{} Informed thread to shut down", (Object)this.logPrefix);
        this.setState(State.PENDING_SHUTDOWN);
    }

    public Map<TaskId, StreamTask> tasks() {
        return Collections.unmodifiableMap(this.activeTasks);
    }

    private void shutdown() {
        log.info("{} Shutting down", (Object)this.logPrefix);
        this.shutdownTasksAndState();
        try {
            this.producer.close();
        }
        catch (Throwable e) {
            log.error("{} Failed to close producer: ", (Object)this.logPrefix, (Object)e);
        }
        try {
            this.consumer.close();
        }
        catch (Throwable e) {
            log.error("{} Failed to close consumer: ", (Object)this.logPrefix, (Object)e);
        }
        try {
            this.restoreConsumer.close();
        }
        catch (Throwable e) {
            log.error("{} Failed to close restore consumer: ", (Object)this.logPrefix, (Object)e);
        }
        try {
            this.partitionAssignor.close();
        }
        catch (Throwable e) {
            log.error("stream-thread [{}] Failed to close KafkaStreamClient: ", (Object)this.getName(), (Object)e);
        }
        this.removeStreamTasks();
        this.removeStandbyTasks();
        log.info("{} Stream thread shutdown complete", (Object)this.logPrefix);
        this.setState(State.NOT_RUNNING);
        this.streamsMetrics.removeAllSensors();
    }

    private RuntimeException unAssignChangeLogPartitions() {
        try {
            this.restoreConsumer.assign(Collections.emptyList());
        }
        catch (RuntimeException e) {
            log.error("{} Failed to un-assign change log partitions: ", (Object)this.logPrefix, (Object)e);
            return e;
        }
        return null;
    }

    private void shutdownTasksAndState() {
        log.debug("{} shutdownTasksAndState: shutting down all active tasks [{}] and standby tasks [{}]", new Object[]{this.logPrefix, this.activeTasks.keySet(), this.standbyTasks.keySet()});
        AtomicReference<Object> firstException = new AtomicReference<Object>(null);
        firstException.compareAndSet(null, this.closeAllTasks());
        firstException.compareAndSet(null, this.flushAllState());
        this.closeAllStateManagers(firstException.get() == null);
        if (this.cleanRun && firstException.get() == null) {
            firstException.set(this.commitOffsets());
        }
        this.unAssignChangeLogPartitions();
    }

    private void suspendTasksAndState() {
        log.debug("{} suspendTasksAndState: suspending all active tasks [{}] and standby tasks [{}]", new Object[]{this.logPrefix, this.activeTasks.keySet(), this.standbyTasks.keySet()});
        AtomicReference<Object> firstException = new AtomicReference<Object>(null);
        firstException.compareAndSet(null, this.closeAllTasksTopologies());
        firstException.compareAndSet(null, this.flushAllState());
        if (firstException.get() == null) {
            firstException.set(this.commitOffsets());
        }
        firstException.compareAndSet(null, this.unAssignChangeLogPartitions());
        this.updateSuspendedTasks();
        if (firstException.get() != null) {
            throw new StreamsException(this.logPrefix + " failed to suspend stream tasks", firstException.get());
        }
    }

    private RuntimeException performOnAllTasks(AbstractTaskAction action, String exceptionMessage) {
        RuntimeException firstException = null;
        ArrayList<StreamTask> allTasks = new ArrayList<StreamTask>(this.activeTasks.values());
        allTasks.addAll(this.standbyTasks.values());
        for (AbstractTask abstractTask : allTasks) {
            try {
                action.apply(abstractTask);
            }
            catch (RuntimeException t) {
                log.error("{} Failed while executing {} {} due to {}: ", new Object[]{this.logPrefix, abstractTask.getClass().getSimpleName(), abstractTask.id(), exceptionMessage, t});
                if (firstException != null) continue;
                firstException = t;
            }
        }
        return firstException;
    }

    private Throwable closeAllStateManagers(final boolean writeCheckpoint) {
        return this.performOnAllTasks(new AbstractTaskAction(){

            @Override
            public void apply(AbstractTask task) {
                log.info("{} Closing the state manager of task {}", (Object)StreamThread.this.logPrefix, (Object)task.id());
                task.closeStateManager(writeCheckpoint);
            }
        }, "close state manager");
    }

    private RuntimeException commitOffsets() {
        return this.performOnAllTasks(new AbstractTaskAction(){

            @Override
            public void apply(AbstractTask task) {
                log.info("{} Committing consumer offsets of task {}", (Object)StreamThread.this.logPrefix, (Object)task.id());
                task.commitOffsets();
            }
        }, "commit consumer offsets");
    }

    private RuntimeException flushAllState() {
        return this.performOnAllTasks(new AbstractTaskAction(){

            @Override
            public void apply(AbstractTask task) {
                log.info("{} Flushing state stores of task {}", (Object)StreamThread.this.logPrefix, (Object)task.id());
                task.flushState();
            }
        }, "flush state");
    }

    private long computeLatency() {
        long previousTimeMs = this.timerStartedMs;
        this.timerStartedMs = this.time.milliseconds();
        return Math.max(this.timerStartedMs - previousTimeMs, 0L);
    }

    private void runLoop() {
        int totalNumBuffered = 0;
        boolean requiresPoll = true;
        boolean polledRecords = false;
        this.consumer.subscribe(this.sourceTopicPattern, this.rebalanceListener);
        while (this.stillRunning()) {
            this.timerStartedMs = this.time.milliseconds();
            if (requiresPoll) {
                requiresPoll = false;
                boolean longPoll = totalNumBuffered == 0;
                ConsumerRecords records = null;
                try {
                    records = this.consumer.poll(longPoll ? this.pollTimeMs : 0L);
                }
                catch (NoOffsetForPartitionException ex) {
                    TopicPartition partition = ex.partition();
                    if (this.builder.earliestResetTopicsPattern().matcher(partition.topic()).matches()) {
                        log.info(String.format("stream-thread [%s] setting topic to consume from earliest offset %s", this.getName(), partition.topic()));
                        this.consumer.seekToBeginning((Collection)ex.partitions());
                    }
                    if (this.builder.latestResetTopicsPattern().matcher(partition.topic()).matches()) {
                        this.consumer.seekToEnd((Collection)ex.partitions());
                        log.info(String.format("stream-thread [%s] setting topic to consume from latest offset %s", this.getName(), partition.topic()));
                    }
                    if (this.originalReset == null || !this.originalReset.equals("earliest") && !this.originalReset.equals("latest")) {
                        this.setState(State.PENDING_SHUTDOWN);
                        String errorMessage = "No valid committed offset found for input topic %s (partition %s) and no valid reset policy configured. You need to set configuration parameter \"auto.offset.reset\" or specify a topic specific reset policy via KStreamBuilder#stream(StreamsConfig.AutoOffsetReset offsetReset, ...) or KStreamBuilder#table(StreamsConfig.AutoOffsetReset offsetReset, ...)";
                        throw new StreamsException(String.format(errorMessage, partition.topic(), partition.partition()), ex);
                    }
                    if (this.originalReset.equals("earliest")) {
                        this.consumer.seekToBeginning((Collection)ex.partitions());
                    } else if (this.originalReset.equals("latest")) {
                        this.consumer.seekToEnd((Collection)ex.partitions());
                    }
                    log.info(String.format("stream-thread [%s] no custom setting defined for topic %s using original config %s for offset reset", this.getName(), partition.topic(), this.originalReset));
                }
                if (this.rebalanceException != null) {
                    throw new StreamsException(this.logPrefix + " Failed to rebalance", this.rebalanceException);
                }
                if (records != null && !records.isEmpty()) {
                    int numAddedRecords = 0;
                    for (TopicPartition partition : records.partitions()) {
                        StreamTask task = this.activeTasksByPartition.get(partition);
                        numAddedRecords += task.addRecords(partition, records.records(partition));
                    }
                    this.streamsMetrics.skippedRecordsSensor.record((double)(records.count() - numAddedRecords), this.timerStartedMs);
                    polledRecords = true;
                } else {
                    polledRecords = false;
                }
                if (longPoll) {
                    this.streamsMetrics.pollTimeSensor.record((double)this.computeLatency());
                }
            }
            if (totalNumBuffered > 0 || polledRecords) {
                totalNumBuffered = 0;
                if (!this.activeTasks.isEmpty()) {
                    for (StreamTask task : this.activeTasks.values()) {
                        totalNumBuffered += task.process();
                        requiresPoll = requiresPoll || task.requiresPoll();
                        this.streamsMetrics.processTimeSensor.record((double)this.computeLatency());
                        this.maybePunctuate(task);
                        if (!task.commitNeeded()) continue;
                        this.commitOne(task);
                    }
                } else {
                    requiresPoll = true;
                }
            } else {
                requiresPoll = true;
            }
            this.maybeCommit();
            this.maybeUpdateStandbyTasks();
            this.maybeClean();
        }
        log.info("{} Shutting down at user request", (Object)this.logPrefix);
    }

    private void maybeUpdateStandbyTasks() {
        if (!this.standbyTasks.isEmpty()) {
            ConsumerRecords records;
            if (this.processStandbyRecords) {
                if (!this.standbyRecords.isEmpty()) {
                    HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>> remainingStandbyRecords = new HashMap<TopicPartition, List<ConsumerRecord<byte[], byte[]>>>();
                    for (TopicPartition partition : this.standbyRecords.keySet()) {
                        List<ConsumerRecord<byte[], byte[]>> remaining = this.standbyRecords.get(partition);
                        if (remaining == null) continue;
                        StandbyTask task = this.standbyTasksByPartition.get(partition);
                        remaining = task.update(partition, remaining);
                        if (remaining != null) {
                            remainingStandbyRecords.put(partition, remaining);
                            continue;
                        }
                        this.restoreConsumer.resume(Collections.singleton(partition));
                    }
                    this.standbyRecords = remainingStandbyRecords;
                }
                this.processStandbyRecords = false;
            }
            if (!(records = this.restoreConsumer.poll(0L)).isEmpty()) {
                for (TopicPartition partition : records.partitions()) {
                    StandbyTask task = this.standbyTasksByPartition.get(partition);
                    if (task == null) {
                        throw new StreamsException(this.logPrefix + " Missing standby task for partition " + partition);
                    }
                    List<ConsumerRecord<byte[], byte[]>> remaining = task.update(partition, records.records(partition));
                    if (remaining == null) continue;
                    this.restoreConsumer.pause(Collections.singleton(partition));
                    this.standbyRecords.put(partition, remaining);
                }
            }
        }
    }

    public synchronized boolean stillRunning() {
        return this.state.isRunning();
    }

    private void maybePunctuate(StreamTask task) {
        try {
            if (task.maybePunctuate()) {
                this.streamsMetrics.punctuateTimeSensor.record((double)this.computeLatency());
            }
        }
        catch (KafkaException e) {
            log.error("{} Failed to punctuate active task {}: ", new Object[]{this.logPrefix, task.id(), e});
            throw e;
        }
    }

    protected void maybeCommit() {
        long now = this.time.milliseconds();
        if (this.commitTimeMs >= 0L && this.lastCommitMs + this.commitTimeMs < now) {
            log.info("{} Committing all tasks because the commit interval {}ms has elapsed", (Object)this.logPrefix, (Object)this.commitTimeMs);
            this.commitAll();
            this.lastCommitMs = now;
            this.processStandbyRecords = true;
        }
    }

    protected void maybeClean() {
        long now = this.time.milliseconds();
        if (now > this.lastCleanMs + this.cleanTimeMs) {
            this.stateDirectory.cleanRemovedTasks();
            this.lastCleanMs = now;
        }
    }

    private void commitAll() {
        log.trace("stream-thread [{}] Committing all its owned tasks", (Object)this.getName());
        for (StreamTask streamTask : this.activeTasks.values()) {
            this.commitOne(streamTask);
        }
        for (StandbyTask standbyTask : this.standbyTasks.values()) {
            this.commitOne(standbyTask);
        }
    }

    private void commitOne(AbstractTask task) {
        log.info("{} Committing task {} {}", new Object[]{this.logPrefix, task.getClass().getSimpleName(), task.id()});
        try {
            task.commit();
        }
        catch (CommitFailedException e) {
            log.warn("{} Failed to commit {} {} state: ", new Object[]{this.logPrefix, task.getClass().getSimpleName(), task.id(), e});
        }
        catch (KafkaException e) {
            log.error("{} Failed to commit {} {} state: ", new Object[]{this.logPrefix, task.getClass().getSimpleName(), task.id(), e});
            throw e;
        }
        this.streamsMetrics.commitTimeSensor.record((double)this.computeLatency());
    }

    public Set<TaskId> prevTasks() {
        return Collections.unmodifiableSet(this.prevTasks);
    }

    public Set<TaskId> cachedTasks() {
        HashSet<TaskId> tasks = new HashSet<TaskId>();
        File[] stateDirs = this.stateDirectory.listTaskDirectories();
        if (stateDirs != null) {
            for (File dir : stateDirs) {
                try {
                    TaskId id = TaskId.parse(dir.getName());
                    if (!new File(dir, ".checkpoint").exists()) continue;
                    tasks.add(id);
                }
                catch (TaskIdFormatException taskIdFormatException) {
                    // empty catch block
                }
            }
        }
        return tasks;
    }

    protected StreamTask createStreamTask(TaskId id, Collection<TopicPartition> partitions) {
        log.info("{} Creating active task {} with assigned partitions [{}]", new Object[]{this.logPrefix, id, partitions});
        this.streamsMetrics.taskCreatedSensor.record();
        ProcessorTopology topology = this.builder.build(id.topicGroupId);
        RecordCollectorImpl recordCollector = new RecordCollectorImpl(this.producer, id.toString());
        return new StreamTask(id, this.applicationId, partitions, topology, this.consumer, this.restoreConsumer, this.config, this.streamsMetrics, this.stateDirectory, this.cache, this.time, recordCollector);
    }

    private StreamTask findMatchingSuspendedTask(TaskId taskId, Set<TopicPartition> partitions) {
        if (this.suspendedTasks.containsKey(taskId)) {
            StreamTask task = this.suspendedTasks.get(taskId);
            if (task.partitions.equals(partitions)) {
                return task;
            }
        }
        return null;
    }

    private StandbyTask findMatchingSuspendedStandbyTask(TaskId taskId, Set<TopicPartition> partitions) {
        if (this.suspendedStandbyTasks.containsKey(taskId)) {
            StandbyTask task = this.suspendedStandbyTasks.get(taskId);
            if (task.partitions.equals(partitions)) {
                return task;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeNonAssignedSuspendedTasks() {
        Map<TaskId, Set<TopicPartition>> newTaskAssignment = this.partitionAssignor.activeTasks();
        Iterator<Map.Entry<TaskId, StreamTask>> suspendedTaskIterator = this.suspendedTasks.entrySet().iterator();
        while (suspendedTaskIterator.hasNext()) {
            Map.Entry<TaskId, StreamTask> next = suspendedTaskIterator.next();
            StreamTask task = next.getValue();
            Set<TopicPartition> assignedPartitionsForTask = newTaskAssignment.get(next.getKey());
            if (task.partitions().equals(assignedPartitionsForTask)) continue;
            log.debug("{} closing suspended non-assigned task", (Object)this.logPrefix);
            try {
                task.close();
                task.closeStateManager(true);
            }
            catch (Exception e) {
                log.error("{} Failed to remove suspended task {}", new Object[]{this.logPrefix, next.getKey(), e});
            }
            finally {
                suspendedTaskIterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeNonAssignedSuspendedStandbyTasks() {
        Set<TaskId> currentSuspendedTaskIds = this.partitionAssignor.standbyTasks().keySet();
        Iterator<Map.Entry<TaskId, StandbyTask>> standByTaskIterator = this.suspendedStandbyTasks.entrySet().iterator();
        while (standByTaskIterator.hasNext()) {
            Map.Entry<TaskId, StandbyTask> suspendedTask = standByTaskIterator.next();
            if (currentSuspendedTaskIds.contains(suspendedTask.getKey())) continue;
            log.debug("{} Closing suspended non-assigned standby task {}", (Object)this.logPrefix, (Object)suspendedTask.getKey());
            StandbyTask task = suspendedTask.getValue();
            try {
                task.close();
                task.closeStateManager(true);
            }
            catch (Exception e) {
                log.error("{} Failed to remove suspended task standby {}", new Object[]{this.logPrefix, suspendedTask.getKey(), e});
            }
            finally {
                standByTaskIterator.remove();
            }
        }
    }

    private void addStreamTasks(Collection<TopicPartition> assignment) {
        if (this.partitionAssignor == null) {
            throw new IllegalStateException(this.logPrefix + " Partition assignor has not been initialized while adding stream tasks: this should not happen.");
        }
        HashMap<TaskId, Set<TopicPartition>> newTasks = new HashMap<TaskId, Set<TopicPartition>>();
        for (Map.Entry<TaskId, Set<TopicPartition>> entry : this.partitionAssignor.activeTasks().entrySet()) {
            TaskId taskId = entry.getKey();
            Set<TopicPartition> partitions = entry.getValue();
            if (assignment.containsAll(partitions)) {
                try {
                    StreamTask task = this.findMatchingSuspendedTask(taskId, partitions);
                    if (task != null) {
                        log.debug("{} recycling old task {}", (Object)this.logPrefix, (Object)taskId);
                        this.suspendedTasks.remove(taskId);
                        task.initTopology();
                        this.activeTasks.put(taskId, task);
                        for (TopicPartition partition : partitions) {
                            this.activeTasksByPartition.put(partition, task);
                        }
                        continue;
                    }
                    newTasks.put(taskId, partitions);
                    continue;
                }
                catch (StreamsException e) {
                    log.error("{} Failed to create an active task {}: ", new Object[]{this.logPrefix, taskId, e});
                    throw e;
                }
            }
            log.warn("{} Task {} owned partitions {} are not contained in the assignment {}", new Object[]{this.logPrefix, taskId, partitions, assignment});
        }
        this.taskCreator.retryWithBackoff(newTasks);
    }

    StandbyTask createStandbyTask(TaskId id, Collection<TopicPartition> partitions) {
        log.info("{} Creating new standby task {} with assigned partitions [{}]", new Object[]{this.logPrefix, id, partitions});
        this.streamsMetrics.taskCreatedSensor.record();
        ProcessorTopology topology = this.builder.build(id.topicGroupId);
        if (!topology.stateStores().isEmpty()) {
            return new StandbyTask(id, this.applicationId, partitions, topology, this.consumer, this.restoreConsumer, this.config, this.streamsMetrics, this.stateDirectory);
        }
        return null;
    }

    private void addStandbyTasks() {
        if (this.partitionAssignor == null) {
            throw new IllegalStateException(this.logPrefix + " Partition assignor has not been initialized while adding standby tasks: this should not happen.");
        }
        HashMap<TopicPartition, Long> checkpointedOffsets = new HashMap<TopicPartition, Long>();
        HashMap<TaskId, Set<TopicPartition>> newStandbyTasks = new HashMap<TaskId, Set<TopicPartition>>();
        for (Map.Entry<TaskId, Set<TopicPartition>> entry : this.partitionAssignor.standbyTasks().entrySet()) {
            Set<TopicPartition> partitions;
            TaskId taskId = entry.getKey();
            StandbyTask task = this.findMatchingSuspendedStandbyTask(taskId, partitions = entry.getValue());
            if (task != null) {
                log.debug("{} recycling old standby task {}", (Object)this.logPrefix, (Object)taskId);
                this.suspendedStandbyTasks.remove(taskId);
                task.initTopology();
            } else {
                newStandbyTasks.put(taskId, partitions);
            }
            this.updateStandByTaskMaps(checkpointedOffsets, taskId, partitions, task);
        }
        new StandbyTaskCreator(checkpointedOffsets).retryWithBackoff(newStandbyTasks);
        this.restoreConsumer.assign(new ArrayList(checkpointedOffsets.keySet()));
        for (Map.Entry<TaskId, Set<Object>> entry : checkpointedOffsets.entrySet()) {
            TopicPartition partition = (TopicPartition)entry.getKey();
            long offset = (Long)((Object)entry.getValue());
            if (offset >= 0L) {
                this.restoreConsumer.seek(partition, offset);
                continue;
            }
            this.restoreConsumer.seekToBeginning(Collections.singleton(partition));
        }
    }

    private void updateStandByTaskMaps(Map<TopicPartition, Long> checkpointedOffsets, TaskId taskId, Set<TopicPartition> partitions, StandbyTask task) {
        if (task != null) {
            this.standbyTasks.put(taskId, task);
            for (TopicPartition partition : partitions) {
                this.standbyTasksByPartition.put(partition, task);
            }
            for (TopicPartition partition : task.checkpointedOffsets().keySet()) {
                this.standbyTasksByPartition.put(partition, task);
            }
            checkpointedOffsets.putAll(task.checkpointedOffsets());
        }
    }

    private void updateSuspendedTasks() {
        log.info("{} Updating suspended tasks to contain active tasks [{}]", (Object)this.logPrefix, this.activeTasks.keySet());
        this.suspendedTasks.clear();
        this.suspendedTasks.putAll(this.activeTasks);
        this.suspendedStandbyTasks.putAll(this.standbyTasks);
    }

    private void removeStreamTasks() {
        log.info("{} Removing all active tasks [{}]", (Object)this.logPrefix, this.activeTasks.keySet());
        try {
            this.prevTasks.clear();
            this.prevTasks.addAll(this.activeTasks.keySet());
            this.activeTasks.clear();
            this.activeTasksByPartition.clear();
        }
        catch (Exception e) {
            log.error("{} Failed to remove stream tasks: ", (Object)this.logPrefix, (Object)e);
        }
    }

    private void removeStandbyTasks() {
        log.info("{} Removing all standby tasks [{}]", (Object)this.logPrefix, this.standbyTasks.keySet());
        this.standbyTasks.clear();
        this.standbyTasksByPartition.clear();
        this.standbyRecords.clear();
    }

    private RuntimeException closeAllTasks() {
        return this.performOnAllTasks(new AbstractTaskAction(){

            @Override
            public void apply(AbstractTask task) {
                log.info("{} Closing a task {}", (Object)StreamThread.this.logPrefix, (Object)task.id());
                task.close();
                ((StreamThread)StreamThread.this).streamsMetrics.tasksClosedSensor.record();
            }
        }, "close");
    }

    private RuntimeException closeAllTasksTopologies() {
        return this.performOnAllTasks(new AbstractTaskAction(){

            @Override
            public void apply(AbstractTask task) {
                log.info("{} Closing a task's topology {}", (Object)StreamThread.this.logPrefix, (Object)task.id());
                task.closeTopology();
                ((StreamThread)StreamThread.this).streamsMetrics.tasksClosedSensor.record();
            }
        }, "close");
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        AbstractTask task;
        StringBuilder sb = new StringBuilder(indent + "StreamsThread appId: " + this.applicationId + "\n");
        sb.append(indent).append("\tStreamsThread clientId: ").append(this.clientId).append("\n");
        sb.append(indent).append("\tStreamsThread threadId: ").append(this.getName()).append("\n");
        if (this.activeTasks != null) {
            sb.append(indent).append("\tActive tasks:\n");
            for (TaskId tId : this.activeTasks.keySet()) {
                task = this.activeTasks.get(tId);
                sb.append(indent).append(task.toString(indent + "\t\t"));
            }
        }
        if (this.standbyTasks != null) {
            sb.append(indent).append("\tStandby tasks:\n");
            for (TaskId tId : this.standbyTasks.keySet()) {
                task = this.standbyTasks.get(tId);
                sb.append(indent).append(task.toString(indent + "\t\t"));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    class StandbyTaskCreator
    extends AbstractTaskCreator {
        private final Map<TopicPartition, Long> checkpointedOffsets;

        StandbyTaskCreator(Map<TopicPartition, Long> checkpointedOffsets) {
            this.checkpointedOffsets = checkpointedOffsets;
        }

        @Override
        void createTask(TaskId taskId, Set<TopicPartition> partitions) {
            log.debug("{} creating new standby task {}", (Object)StreamThread.this.logPrefix, (Object)taskId);
            StandbyTask task = StreamThread.this.createStandbyTask(taskId, partitions);
            StreamThread.this.updateStandByTaskMaps(this.checkpointedOffsets, taskId, partitions, task);
        }
    }

    class TaskCreator
    extends AbstractTaskCreator {
        TaskCreator() {
        }

        @Override
        void createTask(TaskId taskId, Set<TopicPartition> partitions) {
            log.debug("{} creating new task {}", (Object)StreamThread.this.logPrefix, (Object)taskId);
            StreamTask task = StreamThread.this.createStreamTask(taskId, partitions);
            StreamThread.this.activeTasks.put(taskId, task);
            for (TopicPartition partition : partitions) {
                StreamThread.this.activeTasksByPartition.put(partition, task);
            }
        }
    }

    abstract class AbstractTaskCreator {
        AbstractTaskCreator() {
        }

        void retryWithBackoff(Map<TaskId, Set<TopicPartition>> tasksToBeCreated) {
            long backoffTimeMs = 50L;
            while (true) {
                Iterator<Map.Entry<TaskId, Set<TopicPartition>>> it = tasksToBeCreated.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<TaskId, Set<TopicPartition>> newTaskAndPartitions = it.next();
                    TaskId taskId = newTaskAndPartitions.getKey();
                    Set<TopicPartition> partitions = newTaskAndPartitions.getValue();
                    try {
                        this.createTask(taskId, partitions);
                        it.remove();
                    }
                    catch (LockException e) {
                        log.warn("Could not create task {}. Will retry.", (Object)taskId, (Object)e);
                    }
                }
                if (tasksToBeCreated.isEmpty()) break;
                try {
                    Thread.sleep(backoffTimeMs);
                    backoffTimeMs <<= 1;
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        abstract void createTask(TaskId var1, Set<TopicPartition> var2);
    }

    private class StreamsMetricsThreadImpl
    extends StreamsMetricsImpl {
        final Sensor commitTimeSensor;
        final Sensor pollTimeSensor;
        final Sensor processTimeSensor;
        final Sensor punctuateTimeSensor;
        final Sensor taskCreatedSensor;
        final Sensor tasksClosedSensor;
        final Sensor skippedRecordsSensor;

        public StreamsMetricsThreadImpl(Metrics metrics, String groupName, String prefix, Map<String, String> tags) {
            super(metrics, groupName, tags);
            this.commitTimeSensor = metrics.sensor(prefix + ".commit-latency", Sensor.RecordingLevel.INFO);
            this.commitTimeSensor.add(metrics.metricName("commit-latency-avg", this.groupName, "The average commit time in ms", this.tags), (MeasurableStat)new Avg());
            this.commitTimeSensor.add(metrics.metricName("commit-latency-max", this.groupName, "The maximum commit time in ms", this.tags), (MeasurableStat)new Max());
            this.commitTimeSensor.add(metrics.metricName("commit-rate", this.groupName, "The average per-second number of commit calls", this.tags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.pollTimeSensor = metrics.sensor(prefix + ".poll-latency", Sensor.RecordingLevel.INFO);
            this.pollTimeSensor.add(metrics.metricName("poll-latency-avg", this.groupName, "The average poll time in ms", this.tags), (MeasurableStat)new Avg());
            this.pollTimeSensor.add(metrics.metricName("poll-latency-max", this.groupName, "The maximum poll time in ms", this.tags), (MeasurableStat)new Max());
            this.pollTimeSensor.add(metrics.metricName("poll-rate", this.groupName, "The average per-second number of record-poll calls", this.tags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.processTimeSensor = metrics.sensor(prefix + ".process-latency", Sensor.RecordingLevel.INFO);
            this.processTimeSensor.add(metrics.metricName("process-latency-avg", this.groupName, "The average process time in ms", this.tags), (MeasurableStat)new Avg());
            this.processTimeSensor.add(metrics.metricName("process-latency-max", this.groupName, "The maximum process time in ms", this.tags), (MeasurableStat)new Max());
            this.processTimeSensor.add(metrics.metricName("process-rate", this.groupName, "The average per-second number of process calls", this.tags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.punctuateTimeSensor = metrics.sensor(prefix + ".punctuate-latency", Sensor.RecordingLevel.INFO);
            this.punctuateTimeSensor.add(metrics.metricName("punctuate-latency-avg", this.groupName, "The average punctuate time in ms", this.tags), (MeasurableStat)new Avg());
            this.punctuateTimeSensor.add(metrics.metricName("punctuate-latency-max", this.groupName, "The maximum punctuate time in ms", this.tags), (MeasurableStat)new Max());
            this.punctuateTimeSensor.add(metrics.metricName("punctuate-rate", this.groupName, "The average per-second number of punctuate calls", this.tags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.taskCreatedSensor = metrics.sensor(prefix + ".task-created", Sensor.RecordingLevel.INFO);
            this.taskCreatedSensor.add(metrics.metricName("task-created-rate", this.groupName, "The average per-second number of newly created tasks", this.tags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.tasksClosedSensor = metrics.sensor(prefix + ".task-closed", Sensor.RecordingLevel.INFO);
            this.tasksClosedSensor.add(metrics.metricName("task-closed-rate", this.groupName, "The average per-second number of closed tasks", this.tags), (MeasurableStat)new Rate((SampledStat)new Count()));
            this.skippedRecordsSensor = metrics.sensor(prefix + ".skipped-records");
            this.skippedRecordsSensor.add(metrics.metricName("skipped-records-rate", this.groupName, "The average per-second number of skipped records.", this.tags), (MeasurableStat)new Rate((SampledStat)new Count()));
        }

        @Override
        public void recordLatency(Sensor sensor, long startNs, long endNs) {
            sensor.record((double)(endNs - startNs), StreamThread.this.timerStartedMs);
        }

        public void removeAllSensors() {
            this.removeSensor(this.commitTimeSensor);
            this.removeSensor(this.pollTimeSensor);
            this.removeSensor(this.processTimeSensor);
            this.removeSensor(this.punctuateTimeSensor);
            this.removeSensor(this.taskCreatedSensor);
            this.removeSensor(this.tasksClosedSensor);
            this.removeSensor(this.skippedRecordsSensor);
        }
    }

    static interface AbstractTaskAction {
        public void apply(AbstractTask var1);
    }

    public static interface StateListener {
        public void onChange(StreamThread var1, State var2, State var3);
    }

    public static enum State {
        NOT_RUNNING(1),
        RUNNING(1, 2, 4),
        PARTITIONS_REVOKED(3, 4),
        ASSIGNING_PARTITIONS(1, 4),
        PENDING_SHUTDOWN(0);

        private final Set<Integer> validTransitions = new HashSet<Integer>();

        private State(Integer ... validTransitions) {
            this.validTransitions.addAll(Arrays.asList(validTransitions));
        }

        public boolean isRunning() {
            return !this.equals((Object)PENDING_SHUTDOWN) && !this.equals((Object)NOT_RUNNING);
        }

        public boolean isValidTransition(State newState) {
            return this.validTransitions.contains(newState.ordinal());
        }
    }
}

