/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.CacheFlushListener;
import org.apache.kafka.streams.kstream.internals.SessionKeySerde;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.processor.internals.RecordContext;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.internals.CachedStateStore;
import org.apache.kafka.streams.state.internals.HasNextCondition;
import org.apache.kafka.streams.state.internals.LRUCacheEntry;
import org.apache.kafka.streams.state.internals.MergedSortedCacheSessionStoreIterator;
import org.apache.kafka.streams.state.internals.PeekingKeyValueIterator;
import org.apache.kafka.streams.state.internals.SessionKeySchema;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class CachingSessionStore<K, AGG>
extends WrappedStateStore.AbstractWrappedStateStore
implements SessionStore<K, AGG>,
CachedStateStore<Windowed<K>, AGG> {
    private final SessionStore<Bytes, byte[]> bytesStore;
    private final SessionKeySchema keySchema;
    private Serde<K> keySerde;
    private final Serde<AGG> aggSerde;
    private InternalProcessorContext context;
    private String cacheName;
    private StateSerdes<K, AGG> serdes;
    private ThreadCache cache;
    private CacheFlushListener<Windowed<K>, AGG> flushListener;

    CachingSessionStore(SessionStore<Bytes, byte[]> bytesStore, Serde<K> keySerde, Serde<AGG> aggSerde) {
        super(bytesStore);
        this.bytesStore = bytesStore;
        this.keySerde = keySerde;
        this.aggSerde = aggSerde;
        this.keySchema = new SessionKeySchema();
    }

    @Override
    public KeyValueIterator<Windowed<K>, AGG> findSessions(K key, long earliestSessionEndTime, long latestSessionStartTime) {
        this.validateStoreOpen();
        Bytes binarySessionId = Bytes.wrap((byte[])this.keySerde.serializer().serialize(this.name(), key));
        ThreadCache.MemoryLRUCacheBytesIterator cacheIterator = this.cache.range(this.cacheName, this.keySchema.lowerRange(binarySessionId, earliestSessionEndTime).get(), this.keySchema.upperRange(binarySessionId, latestSessionStartTime).get());
        KeyValueIterator<Windowed<Bytes>, byte[]> storeIterator = this.bytesStore.findSessions(binarySessionId, earliestSessionEndTime, latestSessionStartTime);
        HasNextCondition hasNextCondition = this.keySchema.hasNextCondition(binarySessionId, earliestSessionEndTime, latestSessionStartTime);
        FilteredCacheIterator filteredCacheIterator = new FilteredCacheIterator(cacheIterator, hasNextCondition);
        return new MergedSortedCacheSessionStoreIterator<K, AGG>((PeekingKeyValueIterator<Bytes, LRUCacheEntry>)filteredCacheIterator, storeIterator, this.serdes);
    }

    @Override
    public void remove(Windowed<K> sessionKey) {
        this.validateStoreOpen();
        this.put(sessionKey, null);
    }

    @Override
    public void put(Windowed<K> key, AGG value) {
        this.validateStoreOpen();
        Bytes binaryKey = SessionKeySerde.toBinary(key, this.keySerde.serializer());
        LRUCacheEntry entry = new LRUCacheEntry(this.serdes.rawValue(value), true, this.context.offset(), key.window().end(), this.context.partition(), this.context.topic());
        this.cache.put(this.cacheName, binaryKey.get(), entry);
    }

    @Override
    public KeyValueIterator<Windowed<K>, AGG> fetch(K key) {
        return this.findSessions(key, 0L, Long.MAX_VALUE);
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.bytesStore.init(context, root);
        this.initInternal((InternalProcessorContext)context);
    }

    private void initInternal(final InternalProcessorContext context) {
        this.context = context;
        this.serdes = new StateSerdes(this.bytesStore.name(), (Serde<?>)(this.keySerde == null ? context.keySerde() : this.keySerde), (Serde<?>)(this.aggSerde == null ? context.valueSerde() : this.aggSerde));
        this.cacheName = context.taskId() + "-" + this.bytesStore.name();
        this.cache = this.context.getCache();
        this.cache.addDirtyEntryFlushListener(this.cacheName, new ThreadCache.DirtyEntryFlushListener(){

            @Override
            public void apply(List<ThreadCache.DirtyEntry> entries) {
                for (ThreadCache.DirtyEntry entry : entries) {
                    CachingSessionStore.this.putAndMaybeForward(entry, context);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAndMaybeForward(ThreadCache.DirtyEntry entry, InternalProcessorContext context) {
        Bytes binaryKey = entry.key();
        RecordContext current = context.recordContext();
        context.setRecordContext(entry.recordContext());
        try {
            Windowed key = SessionKeySerde.from(binaryKey.get(), this.keySerde.deserializer());
            if (this.flushListener != null) {
                AGG newValue = this.serdes.valueFrom(entry.newValue());
                AGG oldValue = this.fetchPrevious(binaryKey);
                if (newValue != null || oldValue != null) {
                    this.flushListener.apply(key, newValue == null ? null : (Object)newValue, oldValue);
                }
            }
            this.bytesStore.put(new Windowed<Bytes>(Bytes.wrap((byte[])this.serdes.rawKey(key.key())), key.window()), entry.newValue());
        }
        finally {
            context.setRecordContext(current);
        }
    }

    private AGG fetchPrevious(Bytes key) {
        try (KeyValueIterator iterator = this.bytesStore.fetch(key);){
            if (!iterator.hasNext()) {
                AGG AGG = null;
                return AGG;
            }
            AGG AGG = this.serdes.valueFrom((byte[])((KeyValue)iterator.next()).value);
            return AGG;
        }
    }

    @Override
    public void flush() {
        this.cache.flush(this.cacheName);
        this.bytesStore.flush();
    }

    @Override
    public void close() {
        this.flush();
        this.bytesStore.close();
        this.cache.close(this.cacheName);
    }

    @Override
    public void setFlushListener(CacheFlushListener<Windowed<K>, AGG> flushListener) {
        this.flushListener = flushListener;
    }

    private static class FilteredCacheIterator
    implements PeekingKeyValueIterator<Bytes, LRUCacheEntry> {
        private final ThreadCache.MemoryLRUCacheBytesIterator cacheIterator;
        private final HasNextCondition hasNextCondition;

        FilteredCacheIterator(ThreadCache.MemoryLRUCacheBytesIterator cacheIterator, HasNextCondition hasNextCondition) {
            this.cacheIterator = cacheIterator;
            this.hasNextCondition = hasNextCondition;
        }

        @Override
        public void close() {
        }

        @Override
        public Bytes peekNextKey() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.cacheIterator.peekNextKey();
        }

        @Override
        public boolean hasNext() {
            return this.hasNextCondition.hasNext(this.cacheIterator);
        }

        @Override
        public KeyValue<Bytes, LRUCacheEntry> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.cacheIterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public KeyValue<Bytes, LRUCacheEntry> peekNext() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.cacheIterator.peekNext();
        }
    }
}

