/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.processor.ProcessorContext;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.internals.SegmentedBytesStore;
import org.apache.kafka.streams.state.internals.StoreChangeLogger;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;
import org.apache.kafka.streams.state.internals.WrappedStateStore;

class ChangeLoggingSegmentedBytesStore
extends WrappedStateStore.AbstractWrappedStateStore
implements SegmentedBytesStore {
    private final SegmentedBytesStore bytesStore;
    private StoreChangeLogger<Bytes, byte[]> changeLogger;

    ChangeLoggingSegmentedBytesStore(SegmentedBytesStore bytesStore) {
        super(bytesStore);
        this.bytesStore = bytesStore;
    }

    @Override
    public KeyValueIterator<Bytes, byte[]> fetch(Bytes key, long from, long to) {
        return this.bytesStore.fetch(key, from, to);
    }

    @Override
    public void remove(Bytes key) {
        this.bytesStore.remove(key);
        this.changeLogger.logChange(key, null);
    }

    @Override
    public void put(Bytes key, byte[] value) {
        if (key != null) {
            this.bytesStore.put(key, value);
            this.changeLogger.logChange(key, value);
        }
    }

    @Override
    public byte[] get(Bytes key) {
        return this.bytesStore.get(key);
    }

    @Override
    public void init(ProcessorContext context, StateStore root) {
        this.bytesStore.init(context, root);
        this.changeLogger = new StoreChangeLogger<Bytes, byte[]>(this.name(), context, WindowStoreUtils.INNER_SERDES);
    }
}

