/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.tools;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.concurrent.Future;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCompatibilityTest {
    private static final Logger log = LoggerFactory.getLogger(ClientCompatibilityTest.class);
    private final TestConfig testConfig;
    private final byte[] message1;
    private final byte[] message2;

    public static void main(String[] args) throws Exception {
        ArgumentParser parser = ArgumentParsers.newArgumentParser((String)"client-compatibility-test").defaultHelp(true).description("This tool is used to verify client compatibility guarantees.");
        parser.addArgument(new String[]{"--topic"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("topic").metavar(new String[]{"TOPIC"}).help("the compatibility test will produce messages to this topic");
        parser.addArgument(new String[]{"--bootstrap-server"}).action((ArgumentAction)Arguments.store()).required(true).type(String.class).dest("bootstrapServer").metavar(new String[]{"BOOTSTRAP_SERVER"}).help("The server(s) to use for bootstrapping");
        parser.addArgument(new String[]{"--offsets-for-times-supported"}).action((ArgumentAction)Arguments.store()).required(true).type(Boolean.class).dest("offsetsForTimesSupported").metavar(new String[]{"OFFSETS_FOR_TIMES_SUPPORTED"}).help("True if KafkaConsumer#offsetsForTimes is supported by the current broker version");
        parser.addArgument(new String[]{"--cluster-id-supported"}).action((ArgumentAction)Arguments.store()).required(true).type(Boolean.class).dest("clusterIdSupported").metavar(new String[]{"CLUSTER_ID_SUPPORTED"}).help("True if cluster IDs are supported.  False if cluster ID always appears as null.");
        parser.addArgument(new String[]{"--expect-record-too-large-exception"}).action((ArgumentAction)Arguments.store()).required(true).type(Boolean.class).dest("expectRecordTooLargeException").metavar(new String[]{"EXPECT_RECORD_TOO_LARGE_EXCEPTION"}).help("True if we should expect a RecordTooLargeException when trying to read from a topic that contains a message that is bigger than max.partition.fetch.bytes.  This is pre-KIP-74 behavior.");
        Namespace res = null;
        try {
            res = parser.parseArgs(args);
        }
        catch (ArgumentParserException e) {
            if (args.length == 0) {
                parser.printHelp();
                System.exit(0);
            }
            parser.handleError(e);
            System.exit(1);
        }
        TestConfig testConfig = new TestConfig(res);
        ClientCompatibilityTest test = new ClientCompatibilityTest(testConfig);
        try {
            test.run();
        }
        catch (Throwable t) {
            System.out.printf("FAILED: Caught exception %s\n\n", t.getMessage());
            t.printStackTrace();
            System.exit(1);
        }
        System.out.println("SUCCESS.");
        System.exit(0);
    }

    private static String toHexString(byte[] buf) {
        StringBuilder bld = new StringBuilder();
        for (byte b : buf) {
            bld.append(String.format("%02x", b));
        }
        return bld.toString();
    }

    private static void compareArrays(byte[] a, byte[] b) {
        if (!Arrays.equals(a, b)) {
            throw new RuntimeException("Arrays did not match: expected " + ClientCompatibilityTest.toHexString(a) + ", got " + ClientCompatibilityTest.toHexString(b));
        }
    }

    ClientCompatibilityTest(TestConfig testConfig) {
        this.testConfig = testConfig;
        long curTime = Time.SYSTEM.milliseconds();
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.putLong(curTime);
        this.message1 = buf.array();
        ByteBuffer buf2 = ByteBuffer.allocate(4096);
        for (long i = 0L; i < (long)buf2.capacity(); i += 8L) {
            buf2.putLong(curTime + i);
        }
        this.message2 = buf2.array();
    }

    void run() throws Exception {
        long prodTimeMs = Time.SYSTEM.milliseconds();
        this.testProduce();
        this.testConsume(prodTimeMs);
    }

    public void testProduce() throws Exception {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", this.testConfig.bootstrapServer);
        ByteArraySerializer serializer = new ByteArraySerializer();
        KafkaProducer producer = new KafkaProducer(producerProps, (Serializer)serializer, (Serializer)serializer);
        ProducerRecord record1 = new ProducerRecord(this.testConfig.topic, (Object)this.message1);
        Future future1 = producer.send(record1);
        ProducerRecord record2 = new ProducerRecord(this.testConfig.topic, (Object)this.message2);
        Future future2 = producer.send(record2);
        producer.flush();
        future1.get();
        future2.get();
        producer.close();
    }

    public void testConsume(final long prodTimeMs) throws Exception {
        KafkaConsumer consumer;
        block9: {
            Properties consumerProps = new Properties();
            consumerProps.put("bootstrap.servers", this.testConfig.bootstrapServer);
            consumerProps.put("max.partition.fetch.bytes", (Object)512);
            ClientCompatibilityTestDeserializer deserializer = new ClientCompatibilityTestDeserializer(this.testConfig.expectClusterId);
            consumer = new KafkaConsumer(consumerProps, (Deserializer)deserializer, (Deserializer)deserializer);
            List partitionInfos = consumer.partitionsFor(this.testConfig.topic);
            if (partitionInfos.size() < 1) {
                throw new RuntimeException("Expected at least one partition for topic " + this.testConfig.topic);
            }
            final HashMap<TopicPartition, Long> timestampsToSearch = new HashMap<TopicPartition, Long>();
            LinkedList<TopicPartition> topicPartitions = new LinkedList<TopicPartition>();
            for (PartitionInfo partitionInfo : partitionInfos) {
                TopicPartition topicPartition = new TopicPartition(partitionInfo.topic(), partitionInfo.partition());
                timestampsToSearch.put(topicPartition, prodTimeMs);
                topicPartitions.add(topicPartition);
            }
            final OffsetsForTime offsetsForTime = new OffsetsForTime();
            this.tryFeature("offsetsForTimes", this.testConfig.offsetsForTimesSupported, new Runnable(){

                @Override
                public void run() {
                    offsetsForTime.result = consumer.offsetsForTimes(timestampsToSearch);
                }
            }, new Runnable(){

                @Override
                public void run() {
                    log.info("offsetsForTime = {}", offsetsForTime.result);
                }
            });
            consumer.beginningOffsets(timestampsToSearch.keySet());
            consumer.endOffsets(timestampsToSearch.keySet());
            consumer.assign(topicPartitions);
            consumer.seekToBeginning(topicPartitions);
            Iterator<byte[]> iter = new Iterator<byte[]>(){
                private final int timeoutMs = 10000;
                private Iterator<ConsumerRecord<byte[], byte[]>> recordIter = null;
                private byte[] next = null;

                private byte[] fetchNext() {
                    while (true) {
                        long curTime;
                        if ((curTime = Time.SYSTEM.milliseconds()) - prodTimeMs > 10000L) {
                            throw new RuntimeException("Timed out after 10000 ms.");
                        }
                        if (this.recordIter == null) {
                            ConsumerRecords records = consumer.poll(100L);
                            this.recordIter = records.iterator();
                        }
                        if (this.recordIter.hasNext()) {
                            return (byte[])this.recordIter.next().value();
                        }
                        this.recordIter = null;
                    }
                }

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    this.next = this.fetchNext();
                    return this.next != null;
                }

                @Override
                public byte[] next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    byte[] cur = this.next;
                    this.next = null;
                    return cur;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
            byte[] next = (byte[])iter.next();
            try {
                ClientCompatibilityTest.compareArrays(this.message1, next);
                log.debug("Found first message...");
            }
            catch (RuntimeException e) {
                throw new RuntimeException("The first message in this topic was not ours. Please use a new topic when running this program.");
            }
            try {
                next = (byte[])iter.next();
                if (this.testConfig.expectRecordTooLargeException) {
                    throw new RuntimeException("Expected to get a RecordTooLargeException when reading a record bigger than max.partition.fetch.bytes");
                }
                try {
                    ClientCompatibilityTest.compareArrays(this.message2, next);
                }
                catch (RuntimeException e) {
                    System.out.println("The second message in this topic was not ours. Please use a new topic when running this program.");
                    System.exit(1);
                }
            }
            catch (RecordTooLargeException e) {
                log.debug("Got RecordTooLargeException", (Throwable)e);
                if (this.testConfig.expectRecordTooLargeException) break block9;
                throw new RuntimeException("Got an unexpected RecordTooLargeException when reading a record bigger than max.partition.fetch.bytes");
            }
        }
        log.debug("Closing consumer.");
        consumer.close();
        log.info("Closed consumer.");
    }

    private void tryFeature(String featureName, boolean supported, Runnable invoker, Runnable resultTester) {
        try {
            invoker.run();
            log.info("Successfully used feature {}", (Object)featureName);
        }
        catch (UnsupportedVersionException e) {
            log.info("Got UnsupportedVersionException when attempting to use feature {}", (Object)featureName);
            if (supported) {
                throw new RuntimeException("Expected " + featureName + " to be supported, but it wasn't.", e);
            }
            return;
        }
        if (!supported) {
            throw new RuntimeException("Did not expect " + featureName + " to be supported, but it was.");
        }
        resultTester.run();
    }

    public static class ClientCompatibilityTestDeserializer
    implements Deserializer<byte[]>,
    ClusterResourceListener {
        private final boolean expectClusterId;

        ClientCompatibilityTestDeserializer(boolean expectClusterId) {
            this.expectClusterId = expectClusterId;
        }

        public void configure(Map<String, ?> configs, boolean isKey) {
        }

        public byte[] deserialize(String topic, byte[] data) {
            return data;
        }

        public void close() {
        }

        public void onUpdate(ClusterResource clusterResource) {
            if (this.expectClusterId) {
                if (clusterResource.clusterId() == null) {
                    throw new RuntimeException("Expected cluster id to be supported, but it was null.");
                }
            } else if (clusterResource.clusterId() != null) {
                throw new RuntimeException("Expected cluster id to be null, but it was supported.");
            }
        }
    }

    private static class OffsetsForTime {
        Map<TopicPartition, OffsetAndTimestamp> result;

        private OffsetsForTime() {
        }

        public String toString() {
            return Utils.mkString(this.result);
        }
    }

    static class TestConfig {
        final String bootstrapServer;
        final String topic;
        final boolean offsetsForTimesSupported;
        final boolean expectClusterId;
        final boolean expectRecordTooLargeException;

        TestConfig(Namespace res) {
            this.bootstrapServer = res.getString("bootstrapServer");
            this.topic = res.getString("topic");
            this.offsetsForTimesSupported = res.getBoolean("offsetsForTimesSupported");
            this.expectClusterId = res.getBoolean("clusterIdSupported");
            this.expectRecordTooLargeException = res.getBoolean("expectRecordTooLargeException");
        }
    }
}

