/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.kafka.sasl.client;

import com.huawei.middleware.kafka.sasl.client.KafkaSaslClientProvider;
import com.huawei.middleware.kafka.sasl.client.StringUtils;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class KafkaLoginModule
implements LoginModule {
    public static final String SPLIT = "__";
    private static final String AK = "access_key";
    private static final String SK = "secret_key";
    private static final String PROJECT_ID = "project_id";

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        String ak = (String)options.get(AK);
        String sk = (String)options.get(SK);
        String projectId = (String)options.get(PROJECT_ID);
        if (StringUtils.isEmpty(ak, sk, projectId)) {
            throw new IllegalArgumentException("access_key, secret_key or project_id cannot be null or empty.");
        }
        subject.getPublicCredentials().add(ak + SPLIT + projectId);
        subject.getPrivateCredentials().add(sk);
    }

    @Override
    public boolean login() throws LoginException {
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        return false;
    }

    static {
        KafkaSaslClientProvider.initialize();
    }
}

