/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.kafka.sasl.client;

import com.huawei.middleware.kafka.sasl.client.SignUtils;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class KafkaSaslClient
implements SaslClient {
    public static final String MECHANISM = "DMS";
    public static final double VERSION = 1.0;
    private static final String UTF_8 = "UTF-8";
    private static final String SPLIT = "\u0000";
    private boolean complete = false;
    private String ak;
    private String sk;
    private String projectId;

    public KafkaSaslClient(String ak, String sk, String projectId) {
        this.ak = ak;
        this.sk = sk;
        this.projectId = projectId;
    }

    @Override
    public String getMechanismName() {
        return MECHANISM;
    }

    @Override
    public boolean hasInitialResponse() {
        return false;
    }

    @Override
    public byte[] evaluateChallenge(byte[] challenge) throws SaslException {
        if (this.complete) {
            throw new SaslException("DMS challenge has already completed.");
        }
        if (challenge == null || challenge.length == 0) {
            this.complete = true;
            return null;
        }
        try {
            byte[] signData = SignUtils.signBytes(this.ak.getBytes(UTF_8), this.projectId.getBytes(UTF_8), this.sk.getBytes(UTF_8), challenge);
            return SignUtils.concact(this.ak.getBytes(UTF_8), SPLIT.getBytes(UTF_8), this.projectId.getBytes(UTF_8), SPLIT.getBytes(UTF_8), signData);
        }
        catch (Exception e) {
            throw new SaslException("Sign error: " + e.getMessage());
        }
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        if (this.complete) {
            throw new SaslException("DMS supports neither integrity nor privacy");
        }
        throw new IllegalStateException("DMS authentication not completed");
    }

    @Override
    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        if (this.complete) {
            throw new SaslException("DMS supports neither integrity nor privacy");
        }
        throw new IllegalStateException("DMS authentication not completed");
    }

    @Override
    public Object getNegotiatedProperty(String propName) {
        if (this.complete) {
            return null;
        }
        throw new IllegalStateException("DMS authentication not completed");
    }

    @Override
    public void dispose() throws SaslException {
        this.ak = null;
        this.sk = null;
    }
}

