/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.middleware.kafka.sasl.client;

import com.huawei.middleware.kafka.sasl.client.KafkaSaslClient;
import com.huawei.middleware.kafka.sasl.client.StringUtils;
import java.util.Arrays;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;

public class KafkaSaslClientFactory
implements SaslClientFactory {
    private static final String AUTHID_PROMPT = "DMS authentication id: ";
    private static final String PASSWORD_PROMPT = "DMS password: ";

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        return new String[]{"DMS"};
    }

    @Override
    public SaslClient createSaslClient(String[] mechanisms, String authorizationId, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        if (mechanisms.length != 1 || !mechanisms[0].equals("DMS")) {
            throw new SaslException("Unsupported mechanism: " + Arrays.toString(mechanisms) + ", should be: " + "DMS");
        }
        return this.createSaslClient("DMS", cbh);
    }

    private KafkaSaslClient createSaslClient(String mechanism, CallbackHandler callback) throws SaslException {
        NameCallback nameCallBack = new NameCallback(AUTHID_PROMPT);
        PasswordCallback passwdCallBack = new PasswordCallback(PASSWORD_PROMPT, false);
        try {
            callback.handle(new Callback[]{nameCallBack, passwdCallBack});
        }
        catch (Exception e) {
            throw new SaslException("createSaslClient error: " + e.getMessage(), e);
        }
        char[] pwdBytes = passwdCallBack.getPassword();
        if (pwdBytes == null) {
            throw new SaslException("password cannot be null.");
        }
        String password = new String(pwdBytes);
        passwdCallBack.clearPassword();
        String username = nameCallBack.getName();
        if (StringUtils.isEmpty(username)) {
            throw new SaslException("username cannot be null or empty.");
        }
        int authLen = 2;
        String[] authId = username.split("__");
        if (authId.length != 2) {
            throw new SaslException("username format is not correct.");
        }
        return new KafkaSaslClient(authId[0], password, authId[1]);
    }
}

