/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.runtime.PluginDiscovery;
import org.apache.kafka.connect.transforms.Transformation;

public class ConnectorConfig
extends AbstractConfig {
    protected static final String COMMON_GROUP = "Common";
    protected static final String TRANSFORMS_GROUP = "Transforms";
    public static final String NAME_CONFIG = "name";
    private static final String NAME_DOC = "Globally unique name to use for this connector.";
    private static final String NAME_DISPLAY = "Connector name";
    public static final String CONNECTOR_CLASS_CONFIG = "connector.class";
    private static final String CONNECTOR_CLASS_DOC = "Name or alias of the class for this connector. Must be a subclass of org.apache.kafka.connect.connector.Connector. If the connector is org.apache.kafka.connect.file.FileStreamSinkConnector, you can either specify this full name,  or use \"FileStreamSink\" or \"FileStreamSinkConnector\" to make the configuration a bit shorter";
    private static final String CONNECTOR_CLASS_DISPLAY = "Connector class";
    public static final String KEY_CONVERTER_CLASS_CONFIG = "key.converter";
    public static final String KEY_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the keys in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String KEY_CONVERTER_CLASS_DISPLAY = "Key converter class";
    public static final String VALUE_CONVERTER_CLASS_CONFIG = "value.converter";
    public static final String VALUE_CONVERTER_CLASS_DOC = "Converter class used to convert between Kafka Connect format and the serialized form that is written to Kafka. This controls the format of the values in messages written to or read from Kafka, and since this is independent of connectors it allows any connector to work with any serialization format. Examples of common formats include JSON and Avro.";
    public static final String VALUE_CONVERTER_CLASS_DISPLAY = "Value converter class";
    public static final String TASKS_MAX_CONFIG = "tasks.max";
    private static final String TASKS_MAX_DOC = "Maximum number of tasks to use for this connector.";
    public static final int TASKS_MAX_DEFAULT = 1;
    private static final int TASKS_MIN_CONFIG = 1;
    private static final String TASK_MAX_DISPLAY = "Tasks max";
    public static final String TRANSFORMS_CONFIG = "transforms";
    private static final String TRANSFORMS_DOC = "Aliases for the transformations to be applied to records.";
    private static final String TRANSFORMS_DISPLAY = "Transforms";

    public static ConfigDef configDef() {
        return new ConfigDef().define(NAME_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, NAME_DOC, COMMON_GROUP, 1, ConfigDef.Width.MEDIUM, NAME_DISPLAY).define(CONNECTOR_CLASS_CONFIG, ConfigDef.Type.STRING, ConfigDef.Importance.HIGH, CONNECTOR_CLASS_DOC, COMMON_GROUP, 2, ConfigDef.Width.LONG, CONNECTOR_CLASS_DISPLAY).define(TASKS_MAX_CONFIG, ConfigDef.Type.INT, (Object)1, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)1), ConfigDef.Importance.HIGH, TASKS_MAX_DOC, COMMON_GROUP, 3, ConfigDef.Width.SHORT, TASK_MAX_DISPLAY).define(KEY_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, null, ConfigDef.Importance.LOW, KEY_CONVERTER_CLASS_DOC, COMMON_GROUP, 4, ConfigDef.Width.SHORT, KEY_CONVERTER_CLASS_DISPLAY).define(VALUE_CONVERTER_CLASS_CONFIG, ConfigDef.Type.CLASS, null, ConfigDef.Importance.LOW, VALUE_CONVERTER_CLASS_DOC, COMMON_GROUP, 5, ConfigDef.Width.SHORT, VALUE_CONVERTER_CLASS_DISPLAY).define(TRANSFORMS_CONFIG, ConfigDef.Type.LIST, null, new ConfigDef.Validator(){

            public void ensureValid(String name, Object value) {
                if (value == null) {
                    return;
                }
                List transformAliases = (List)value;
                if (transformAliases.size() > new HashSet(transformAliases).size()) {
                    throw new ConfigException(name, value, "Duplicate alias provided.");
                }
            }
        }, ConfigDef.Importance.LOW, TRANSFORMS_DOC, "Transforms", 6, ConfigDef.Width.LONG, "Transforms");
    }

    public ConnectorConfig() {
        this(new HashMap<String, String>());
    }

    public ConnectorConfig(Map<String, String> props) {
        this(ConnectorConfig.configDef(), props);
    }

    public ConnectorConfig(ConfigDef configDef, Map<String, String> props) {
        super(ConnectorConfig.enrich(configDef, props, true), props);
    }

    public <R extends ConnectRecord<R>> List<Transformation<R>> transformations() {
        List transformAliases = this.getList(TRANSFORMS_CONFIG);
        if (transformAliases == null || transformAliases.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Transformation<R>> transformations = new ArrayList<Transformation<R>>(transformAliases.size());
        for (String alias : transformAliases) {
            Transformation transformation;
            String prefix = "transforms." + alias + ".";
            try {
                transformation = this.getClass(prefix + "type").asSubclass(Transformation.class).newInstance();
            }
            catch (Exception e) {
                throw new ConnectException((Throwable)e);
            }
            transformation.configure(this.originalsWithPrefix(prefix));
            transformations.add(transformation);
        }
        return transformations;
    }

    public static ConfigDef enrich(ConfigDef baseConfigDef, Map<String, String> props, boolean requireFullConfig) {
        List transformAliases = (List)ConfigDef.parseType((String)TRANSFORMS_CONFIG, (Object)props.get(TRANSFORMS_CONFIG), (ConfigDef.Type)ConfigDef.Type.LIST);
        if (transformAliases == null || transformAliases.isEmpty()) {
            return baseConfigDef;
        }
        ConfigDef newDef = new ConfigDef(baseConfigDef);
        for (String alias : new LinkedHashSet(transformAliases)) {
            ConfigDef transformationConfigDef;
            String prefix = "transforms." + alias + ".";
            String group = "Transforms: " + alias;
            int orderInGroup = 0;
            final String transformationTypeConfig = prefix + "type";
            ConfigDef.Validator typeValidator = new ConfigDef.Validator(){

                public void ensureValid(String name, Object value) {
                    ConnectorConfig.getConfigDefFromTransformation(transformationTypeConfig, (Class)value);
                }
            };
            newDef.define(transformationTypeConfig, ConfigDef.Type.CLASS, ConfigDef.NO_DEFAULT_VALUE, typeValidator, ConfigDef.Importance.HIGH, "Class for the '" + alias + "' transformation.", group, orderInGroup++, ConfigDef.Width.LONG, "Transformation type for " + alias, Collections.emptyList(), (ConfigDef.Recommender)new TransformationClassRecommender());
            try {
                String className = props.get(transformationTypeConfig);
                Class cls = (Class)ConfigDef.parseType((String)transformationTypeConfig, (Object)className, (ConfigDef.Type)ConfigDef.Type.CLASS);
                transformationConfigDef = ConnectorConfig.getConfigDefFromTransformation(transformationTypeConfig, cls);
            }
            catch (ConfigException e) {
                if (!requireFullConfig) continue;
                throw e;
            }
            newDef.embed(prefix, group, orderInGroup, transformationConfigDef);
        }
        return newDef;
    }

    static ConfigDef getConfigDefFromTransformation(String key, Class<?> transformationCls) {
        if (transformationCls == null || !Transformation.class.isAssignableFrom(transformationCls)) {
            throw new ConfigException(key, (Object)String.valueOf(transformationCls), "Not a Transformation");
        }
        try {
            return transformationCls.asSubclass(Transformation.class).newInstance().config();
        }
        catch (Exception e) {
            throw new ConfigException(key, (Object)String.valueOf(transformationCls), "Error getting config definition from Transformation: " + e.getMessage());
        }
    }

    static final class TransformationClassRecommender
    implements ConfigDef.Recommender {
        TransformationClassRecommender() {
        }

        public List<Object> validValues(String name, Map<String, Object> parsedConfig) {
            return PluginDiscovery.transformationPlugins();
        }

        public boolean visible(String name, Map<String, Object> parsedConfig) {
            return true;
        }
    }
}

