/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.transforms;

import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.ConnectSchema;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.transforms.Transformation;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.apache.kafka.connect.transforms.util.SimpleConfig;

public abstract class SetSchemaMetadata<R extends ConnectRecord<R>>
implements Transformation<R> {
    public static final String OVERVIEW_DOC = "Set the schema name, version or both on the record's key (<code>" + Key.class.getCanonicalName() + "</code>)" + " or value (<code>" + Value.class.getCanonicalName() + "</code>) schema.";
    public static final ConfigDef CONFIG_DEF = new ConfigDef().define("schema.name", ConfigDef.Type.STRING, null, ConfigDef.Importance.HIGH, "Schema name to set.").define("schema.version", ConfigDef.Type.INT, null, ConfigDef.Importance.HIGH, "Schema version to set.");
    private String schemaName;
    private Integer schemaVersion;

    public void configure(Map<String, ?> configs) {
        SimpleConfig config = new SimpleConfig(CONFIG_DEF, configs);
        this.schemaName = config.getString("schema.name");
        this.schemaVersion = config.getInt("schema.version");
        if (this.schemaName == null && this.schemaVersion == null) {
            throw new ConfigException("Neither schema name nor version configured");
        }
    }

    public R apply(R record) {
        Schema schema = this.operatingSchema(record);
        Requirements.requireSchema(schema, "updating schema metadata");
        boolean isArray = schema.type() == Schema.Type.ARRAY;
        boolean isMap = schema.type() == Schema.Type.MAP;
        ConnectSchema updatedSchema = new ConnectSchema(schema.type(), schema.isOptional(), schema.defaultValue(), this.schemaName != null ? this.schemaName : schema.name(), this.schemaVersion != null ? this.schemaVersion : schema.version(), schema.doc(), schema.parameters(), schema.fields(), isMap ? schema.keySchema() : null, (Schema)(isMap || isArray ? schema.valueSchema() : null));
        return this.newRecord(record, (Schema)updatedSchema);
    }

    public ConfigDef config() {
        return CONFIG_DEF;
    }

    public void close() {
    }

    protected abstract Schema operatingSchema(R var1);

    protected abstract R newRecord(R var1, Schema var2);

    public static class Value<R extends ConnectRecord<R>>
    extends SetSchemaMetadata<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return record.valueSchema();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema) {
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), record.keySchema(), record.key(), updatedSchema, record.value(), record.timestamp());
        }
    }

    public static class Key<R extends ConnectRecord<R>>
    extends SetSchemaMetadata<R> {
        @Override
        protected Schema operatingSchema(R record) {
            return record.keySchema();
        }

        @Override
        protected R newRecord(R record, Schema updatedSchema) {
            return (R)record.newRecord(record.topic(), record.kafkaPartition(), updatedSchema, record.key(), record.valueSchema(), record.value(), record.timestamp());
        }
    }

    private static interface ConfigName {
        public static final String SCHEMA_NAME = "schema.name";
        public static final String SCHEMA_VERSION = "schema.version";
    }
}

