/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.api.PartitionMetadata;
import kafka.api.TopicMetadata;
import kafka.client.ClientUtils$;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#\u00113e!\u0006\u0014H/\u001b;j_:\u001cH+Z:u\u0015\t\u0019A!A\u0003bI6LgNC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u0013!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uKB\u00111CF\u0007\u0002))\u0011Q\u0003B\u0001\u0003u.L!a\u0006\u000b\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t!\u0001C\u0004\u001f\u0001\u0001\u0007I\u0011A\u0010\u0002\u000f\r|gNZ5hgV\t\u0001\u0005E\u0002\"W9r!A\t\u0015\u000f\u0005\r2S\"\u0001\u0013\u000b\u0005\u00152\u0011A\u0002\u001fs_>$h(C\u0001(\u0003\u0015\u00198-\u00197b\u0013\tI#&A\u0004qC\u000e\\\u0017mZ3\u000b\u0003\u001dJ!\u0001L\u0017\u0003\u0007M+\u0017O\u0003\u0002*UA\u0011qFM\u0007\u0002a)\u0011\u0011\u0007B\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005M\u0002$aC&bM.\f7i\u001c8gS\u001eDq!\u000e\u0001A\u0002\u0013\u0005a'A\u0006d_:4\u0017nZ:`I\u0015\fHCA\u001c<!\tA\u0014(D\u0001+\u0013\tQ$F\u0001\u0003V]&$\bb\u0002\u001f5\u0003\u0003\u0005\r\u0001I\u0001\u0004q\u0012\n\u0004B\u0002 \u0001A\u0003&\u0001%\u0001\u0005d_:4\u0017nZ:!\u0011\u001d\u0001\u0005\u00011A\u0005\u0002\u0005\u000bqa]3sm\u0016\u00148/F\u0001C!\r\t3f\u0011\t\u0003_\u0011K!!\u0012\u0019\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\b\u000f\u0002\u0001\r\u0011\"\u0001I\u0003-\u0019XM\u001d<feN|F%Z9\u0015\u0005]J\u0005b\u0002\u001fG\u0003\u0003\u0005\rA\u0011\u0005\u0007\u0017\u0002\u0001\u000b\u0015\u0002\"\u0002\u0011M,'O^3sg\u0002Bq!\u0014\u0001A\u0002\u0013\u0005a*A\u0004ce>\\WM]:\u0016\u0003=\u00032!I\u0016Q!\t\tF+D\u0001S\u0015\t\u0019F!A\u0004dYV\u001cH/\u001a:\n\u0005U\u0013&A\u0002\"s_.,'\u000fC\u0004X\u0001\u0001\u0007I\u0011\u0001-\u0002\u0017\t\u0014xn[3sg~#S-\u001d\u000b\u0003oeCq\u0001\u0010,\u0002\u0002\u0003\u0007q\n\u0003\u0004\\\u0001\u0001\u0006KaT\u0001\tEJ|7.\u001a:tA!9Q\f\u0001b\u0001\n\u0003q\u0016a\u00039beRLG/[8o\u0013\u0012,\u0012a\u0018\t\u0003q\u0001L!!\u0019\u0016\u0003\u0007%sG\u000f\u0003\u0004d\u0001\u0001\u0006IaX\u0001\ra\u0006\u0014H/\u001b;j_:LE\r\t\u0005\bK\u0002\u0011\r\u0011\"\u0001g\u0003\u0019!x\u000e]5dcU\tq\r\u0005\u0002i[6\t\u0011N\u0003\u0002kW\u0006!A.\u00198h\u0015\u0005a\u0017\u0001\u00026bm\u0006L!A\\5\u0003\rM#(/\u001b8h\u0011\u0019\u0001\b\u0001)A\u0005O\u00069Ao\u001c9jGF\u0002\u0003b\u0002:\u0001\u0005\u0004%\tAZ\u0001\u0007i>\u0004\u0018n\u0019\u001a\t\rQ\u0004\u0001\u0015!\u0003h\u0003\u001d!x\u000e]5de\u0001BqA\u001e\u0001C\u0002\u0013\u0005a-\u0001\u0004u_BL7m\r\u0005\u0007q\u0002\u0001\u000b\u0011B4\u0002\u000fQ|\u0007/[24A!9!\u0010\u0001b\u0001\n\u00031\u0017A\u0002;pa&\u001cG\u0007\u0003\u0004}\u0001\u0001\u0006IaZ\u0001\bi>\u0004\u0018n\u0019\u001b!\u0011\u0015q\b\u0001\"\u0011\u0000\u0003\u0015\u0019X\r^+q)\u00059\u0004fA?\u0002\u0004A!\u0011QAA\u0005\u001b\t\t9A\u0003\u0002\f\u001d%!\u00111BA\u0004\u0005\u0019\u0011UMZ8sK\"1\u0011q\u0002\u0001\u0005B}\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u0003\u001b\t\u0019\u0002\u0005\u0003\u0002\u0006\u0005U\u0011\u0002BA\f\u0003\u000f\u0011Q!\u00114uKJDq!a\u0007\u0001\t\u0003\ti\"A\u000buKN$Hk\u001c9jG\u0012{Wm\u001d(pi\u0016C\u0018n\u001d;\u0016\u0003]BC!!\u0007\u0002\"A!\u0011QAA\u0012\u0013\u0011\t)#a\u0002\u0003\tQ+7\u000f\u001e\u0005\b\u0003S\u0001A\u0011AA\u000f\u0003U!Xm\u001d;Xe>twMU3qY&\u001c\u0017mQ8v]RDC!a\n\u0002\"!9\u0011q\u0006\u0001\u0005\u0002\u0005u\u0011a\u0006;fgRLen\u0019:f[\u0016tG\u000fU1si&$\u0018n\u001c8tQ\u0011\ti#!\t\t\u000f\u0005U\u0002\u0001\"\u0001\u0002\u001e\u0005qB/Z:u\u001b\u0006tW/\u00197BgNLwM\\7f]R|eMU3qY&\u001c\u0017m\u001d\u0015\u0005\u0003g\t\t\u0003C\u0004\u0002<\u0001!\t!!\b\u0002=Q,7\u000f\u001e*fa2L7-\u0019)mC\u000e,W.\u001a8u\u00032d7+\u001a:wKJ\u001c\b\u0006BA\u001d\u0003CAq!!\u0011\u0001\t\u0003\ti\"\u0001\u0012uKN$(+\u001a9mS\u000e\f\u0007\u000b\\1dK6,g\u000e\u001e)beRL\u0017\r\\*feZ,'o\u001d\u0015\u0005\u0003\u007f\t\t\u0003C\u0004\u0002H\u0001!\t!!\u0013\u00023Y\fG.\u001b3bi\u0016dU-\u00193fe\u0006sGMU3qY&\u001c\u0017m\u001d\u000b\no\u0005-\u00131LA/\u0003CB\u0001\"!\u0014\u0002F\u0001\u0007\u0011qJ\u0001\t[\u0016$\u0018\rZ1uCB!\u0011\u0011KA,\u001b\t\t\u0019FC\u0002\u0002V\u0011\t1!\u00199j\u0013\u0011\tI&a\u0015\u0003\u001bQ{\u0007/[2NKR\fG-\u0019;b\u0011\u0019i\u0016Q\ta\u0001?\"9\u0011qLA#\u0001\u0004y\u0016\u0001E3ya\u0016\u001cG/\u001a3MK\u0006$WM]%e\u0011!\t\u0019'!\u0012A\u0002\u0005\u0015\u0014\u0001E3ya\u0016\u001cG/\u001a3SKBd\u0017nY1t!\u0015\t9'!\u001c`\u001d\rA\u0014\u0011N\u0005\u0004\u0003WR\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002p\u0005E$aA*fi*\u0019\u00111\u000e\u0016")
public class AddPartitionsTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private Seq<KafkaConfig> configs;
    private Seq<KafkaServer> servers;
    private Seq<Broker> brokers;
    private final int partitionId;
    private final String topic1;
    private final String topic2;
    private final String topic3;
    private final String topic4;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AddPartitionsTest addPartitionsTest = this;
        synchronized (addPartitionsTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public Seq<Broker> brokers() {
        return this.brokers;
    }

    public void brokers_$eq(Seq<Broker> x$1) {
        this.brokers = x$1;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    public String topic3() {
        return this.topic3;
    }

    public String topic4() {
        return this.topic4;
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
        this.configs_$eq((Seq<KafkaConfig>)((Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 4).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final KafkaConfig apply(int i) {
                return KafkaConfig$.MODULE$.fromProps(TestUtils$.MODULE$.createBrokerConfig(i, this.$outer.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16()));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())));
        this.servers_$eq((Seq<KafkaServer>)((Seq)this.configs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KafkaServer apply(KafkaConfig c) {
                return TestUtils$.MODULE$.createServer(c, TestUtils$.MODULE$.createServer$default$2());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        this.brokers_$eq((Seq<Broker>)((Seq)this.servers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Broker apply(KafkaServer s) {
                return TestUtils$.MODULE$.createBroker(s.config().brokerId(), s.config().hostName(), TestUtils$.MODULE$.boundPort(s, TestUtils$.MODULE$.boundPort$default$2()), TestUtils$.MODULE$.createBroker$default$4());
            }
        }, Seq$.MODULE$.canBuildFrom())));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic1(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic2(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic3(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic4(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3})))}))), this.servers());
    }

    @Override
    @After
    public void tearDown() {
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer x$1) {
                x$1.shutdown();
            }
        });
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer server) {
                CoreUtils$.MODULE$.delete(server.config().logDirs());
            }
        });
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testTopicDoesNotExist() {
        try {
            AdminUtils$.MODULE$.addPartitions(this.zkUtils(), "Blah", 1, AdminUtils$.MODULE$.addPartitions$default$4(), AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
            throw this.fail("Topic should not exist", new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
        }
        catch (AdminOperationException adminOperationException) {
            return;
        }
    }

    @Test
    public void testWrongReplicaCount() {
        try {
            AdminUtils$.MODULE$.addPartitions(this.zkUtils(), this.topic1(), 2, "0:1,0:1:2", AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
            throw this.fail("Add partitions should fail", new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 81));
        }
        catch (AdminOperationException adminOperationException) {
            return;
        }
    }

    @Test
    public void testIncrementPartitions() {
        AdminUtils$.MODULE$.addPartitions(this.zkUtils(), this.topic1(), 3, AdminUtils$.MODULE$.addPartitions$default$4(), AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
        Option<Object> leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Option<Object> leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkUtils().getLeaderForPartition(this.topic1(), 1).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkUtils().getLeaderForPartition(this.topic1(), 2).get());
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)leader1.get()), (long)leader1FromZk);
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)leader2.get()), (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic1(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic1(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        ListenerName listenerName = ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT);
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic1()})), (Seq)this.brokers().map((Function1)new Serializable(this, listenerName){
            public static final long serialVersionUID = 0L;
            private final ListenerName listenerName$1;

            public final BrokerEndPoint apply(Broker x$2) {
                return x$2.getBrokerEndPoint(this.listenerName$1);
            }
            {
                this.listenerName$1 = listenerName$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), "AddPartitionsTest-testIncrementPartitions", 2000, 0).topicsMetadata();
        Seq metaDataForTopic1 = (Seq)metadata.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final boolean apply(TopicMetadata p) {
                return p.topic().equals(this.$outer.topic1());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq partitionDataForTopic1 = (Seq)((TopicMetadata)metaDataForTopic1.head()).partitionsMetadata().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(PartitionMetadata x$3) {
                return x$3.partitionId();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)partitionDataForTopic1.size(), (long)3L);
        Assert.assertEquals((long)((PartitionMetadata)partitionDataForTopic1.apply(1)).partitionId(), (long)1L);
        Assert.assertEquals((long)((PartitionMetadata)partitionDataForTopic1.apply(2)).partitionId(), (long)2L);
        Seq replicas = ((PartitionMetadata)partitionDataForTopic1.apply(1)).replicas();
        Assert.assertEquals((long)replicas.size(), (long)2L);
        Seq $org_scalatest_assert_macro_left = replicas;
        BrokerEndPoint $org_scalatest_assert_macro_right = (BrokerEndPoint)((PartitionMetadata)partitionDataForTopic1.apply(1)).leader().get();
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
    }

    @Test
    public void testManualAssignmentOfReplicas() {
        Bool bool;
        Bool bool2;
        AdminUtils$.MODULE$.addPartitions(this.zkUtils(), this.topic2(), 3, "1:2,0:1,2:3", AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
        Option<Object> leader1 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Option<Object> leader2 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        int leader1FromZk = BoxesRunTime.unboxToInt((Object)this.zkUtils().getLeaderForPartition(this.topic2(), 1).get());
        int leader2FromZk = BoxesRunTime.unboxToInt((Object)this.zkUtils().getLeaderForPartition(this.topic2(), 2).get());
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)leader1.get()), (long)leader1FromZk);
        Assert.assertEquals((long)BoxesRunTime.unboxToInt((Object)leader2.get()), (long)leader2FromZk);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()})), (Seq)this.brokers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerEndPoint apply(Broker x$4) {
                return x$4.getBrokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
            }
        }, Seq$.MODULE$.canBuildFrom()), "AddPartitionsTest-testManualAssignmentOfReplicas", 2000, 0).topicsMetadata();
        Seq metaDataForTopic2 = (Seq)metadata.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final boolean apply(TopicMetadata p) {
                return p.topic().equals(this.$outer.topic2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        Seq partitionDataForTopic2 = (Seq)((TopicMetadata)metaDataForTopic2.head()).partitionsMetadata().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(PartitionMetadata x$5) {
                return x$5.partitionId();
            }
        }, (Ordering)Ordering.Int$.MODULE$);
        Assert.assertEquals((long)partitionDataForTopic2.size(), (long)3L);
        Assert.assertEquals((long)((PartitionMetadata)partitionDataForTopic2.apply(1)).partitionId(), (long)1L);
        Assert.assertEquals((long)((PartitionMetadata)partitionDataForTopic2.apply(2)).partitionId(), (long)2L);
        Seq replicas = ((PartitionMetadata)partitionDataForTopic2.apply(1)).replicas();
        Assert.assertEquals((long)replicas.size(), (long)2L);
        int $org_scalatest_assert_macro_left = ((BrokerEndPoint)replicas.head()).id();
        int $org_scalatest_assert_macro_right = 0;
        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        if ($org_scalatest_assert_macro_left2.value()) {
            bool2 = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
        } else {
            int $org_scalatest_assert_macro_left3 = ((BrokerEndPoint)replicas.head()).id();
            int $org_scalatest_assert_macro_right2 = 1;
            bool2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left3), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left3 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        }
        Bool $org_scalatest_assert_macro_right3 = bool2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "||", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$bar$bar((Function0)new Serializable(this, $org_scalatest_assert_macro_right3){
            public static final long serialVersionUID = 0L;
            private final Bool $org_scalatest_assert_macro_right$1;

            public final Bool apply() {
                return this.$org_scalatest_assert_macro_right$1;
            }
            {
                this.$org_scalatest_assert_macro_right$1 = $org_scalatest_assert_macro_right$1;
            }
        }), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 138));
        int $org_scalatest_assert_macro_left4 = ((BrokerEndPoint)replicas.apply(1)).id();
        int $org_scalatest_assert_macro_right4 = 0;
        Bool $org_scalatest_assert_macro_left5 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left4), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), $org_scalatest_assert_macro_left4 == $org_scalatest_assert_macro_right4, Prettifier$.MODULE$.default());
        if ($org_scalatest_assert_macro_left5.value()) {
            bool = Bool$.MODULE$.simpleMacroBool(true, "", Prettifier$.MODULE$.default());
        } else {
            int $org_scalatest_assert_macro_left6 = ((BrokerEndPoint)replicas.apply(1)).id();
            int $org_scalatest_assert_macro_right5 = 1;
            bool = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left6), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right5), $org_scalatest_assert_macro_left6 == $org_scalatest_assert_macro_right5, Prettifier$.MODULE$.default());
        }
        Bool $org_scalatest_assert_macro_right6 = bool;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "||", (Object)$org_scalatest_assert_macro_right6, $org_scalatest_assert_macro_left5.$bar$bar((Function0)new Serializable(this, $org_scalatest_assert_macro_right6){
            public static final long serialVersionUID = 0L;
            private final Bool $org_scalatest_assert_macro_right$2;

            public final Bool apply() {
                return this.$org_scalatest_assert_macro_right$2;
            }
            {
                this.$org_scalatest_assert_macro_right$2 = $org_scalatest_assert_macro_right$2;
            }
        }), Prettifier$.MODULE$.default());
        this.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("AddPartitionsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
    }

    @Test
    public void testReplicaPlacementAllServers() {
        AdminUtils$.MODULE$.addPartitions(this.zkUtils(), this.topic3(), 7, AdminUtils$.MODULE$.addPartitions$default$4(), AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 3, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 4, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 5, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic3(), 6, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic3()})), (Seq)this.brokers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerEndPoint apply(Broker x$6) {
                return x$6.getBrokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
            }
        }, Seq$.MODULE$.canBuildFrom()), "AddPartitionsTest-testReplicaPlacementAllServers", 2000, 0).topicsMetadata();
        TopicMetadata metaDataForTopic3 = (TopicMetadata)metadata.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final boolean apply(TopicMetadata p) {
                String string = p.topic();
                String string2 = this.$outer.topic3();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get();
        this.validateLeaderAndReplicas(metaDataForTopic3, 0, 2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 1, 3, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 2, 0, 1}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 2, 0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 3, 1, 2}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 3, 1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 2, 3}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 4, 2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 0, 1}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 5, 3, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 0, 1, 2}))));
        this.validateLeaderAndReplicas(metaDataForTopic3, 6, 0, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
    }

    @Test
    public void testReplicaPlacementPartialServers() {
        AdminUtils$.MODULE$.addPartitions(this.zkUtils(), this.topic2(), 3, AdminUtils$.MODULE$.addPartitions$default$4(), AdminUtils$.MODULE$.addPartitions$default$5(), AdminUtils$.MODULE$.addPartitions$default$6());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic2(), 1, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated(this.servers(), this.topic2(), 2, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        Seq metadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic2()})), (Seq)this.brokers().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final BrokerEndPoint apply(Broker x$7) {
                return x$7.getBrokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
            }
        }, Seq$.MODULE$.canBuildFrom()), "AddPartitionsTest-testReplicaPlacementPartialServers", 2000, 0).topicsMetadata();
        TopicMetadata metaDataForTopic2 = (TopicMetadata)metadata.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AddPartitionsTest $outer;

            public final boolean apply(TopicMetadata p) {
                String string = p.topic();
                String string2 = this.$outer.topic2();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get();
        this.validateLeaderAndReplicas(metaDataForTopic2, 0, 1, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))));
        this.validateLeaderAndReplicas(metaDataForTopic2, 1, 2, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2}))));
        this.validateLeaderAndReplicas(metaDataForTopic2, 2, 3, (scala.collection.immutable.Set<Object>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3}))));
    }

    public void validateLeaderAndReplicas(TopicMetadata metadata, int partitionId, int expectedLeaderId, scala.collection.immutable.Set<Object> expectedReplicas) {
        Option partitionOpt = metadata.partitionsMetadata().find((Function1)new Serializable(this, partitionId){
            public static final long serialVersionUID = 0L;
            private final int partitionId$1;

            public final boolean apply(PartitionMetadata x$8) {
                return x$8.partitionId() == this.partitionId$1;
            }
            {
                this.partitionId$1 = partitionId$1;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition ", " should exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)partitionId)})), (boolean)partitionOpt.isDefined());
        PartitionMetadata partition = (PartitionMetadata)partitionOpt.get();
        Assert.assertTrue((String)"Partition leader should exist", (boolean)partition.leader().isDefined());
        Assert.assertEquals((String)"Partition leader id should match", (long)expectedLeaderId, (long)((BrokerEndPoint)partition.leader().get()).id());
        Assert.assertEquals((String)"Replica set should match", expectedReplicas, (Object)((TraversableOnce)partition.replicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(BrokerEndPoint x$9) {
                return x$9.id();
            }
        }, Seq$.MODULE$.canBuildFrom())).toSet());
    }

    public AddPartitionsTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.configs = null;
        this.servers = (Seq)Seq$.MODULE$.empty();
        this.brokers = (Seq)Seq$.MODULE$.empty();
        this.partitionId = 0;
        this.topic1 = "new-topic1";
        this.topic2 = "new-topic2";
        this.topic3 = "new-topic3";
        this.topic4 = "new-topic4";
    }
}

