/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import kafka.cluster.Broker;
import kafka.cluster.EndPoint;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001=3A!\u0001\u0002\u0001\u000f\t\u0019\u0012\t\u001a<feRL7/\u001a\"s_.,'\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\tQ8.\u0003\u0002\u0018)\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgNDQ!\u0007\u0001\u0005\u0002i\ta\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"\u0001\u0002\t\u000fy\u0001!\u0019!C\u0001?\u000591/\u001a:wKJ\u001cX#\u0001\u0011\u0011\u0007\u0005B#&D\u0001#\u0015\t\u0019C%A\u0004nkR\f'\r\\3\u000b\u0005\u00152\u0013AC2pY2,7\r^5p]*\tq%A\u0003tG\u0006d\u0017-\u0003\u0002*E\tY\u0011I\u001d:bs\n+hMZ3s!\ta2&\u0003\u0002-\u0005\tY1*\u00194lCN+'O^3s\u0011\u0019q\u0003\u0001)A\u0005A\u0005A1/\u001a:wKJ\u001c\b\u0005C\u00041\u0001\t\u0007I\u0011A\u0019\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012A\r\t\u0003gQj\u0011AJ\u0005\u0003k\u0019\u00121!\u00138u\u0011\u00199\u0004\u0001)A\u0005e\u0005I!M]8lKJLE\r\t\u0005\u0006s\u0001!\tEO\u0001\ti\u0016\f'\u000fR8x]R\t1\b\u0005\u00024y%\u0011QH\n\u0002\u0005+:LG\u000f\u000b\u00029\u007fA\u0011\u0001IQ\u0007\u0002\u0003*\u00111BD\u0005\u0003\u0007\u0006\u0013Q!\u00114uKJDQ!\u0012\u0001\u0005\u0002\u0019\u000ba\u0005^3ti\n\u0013xn[3s\u0003\u00124XM\u001d;jg\u0016Dun\u001d;OC6,\u0017I\u001c3Q_J$Hk\u001c.L+\u0005Y\u0004F\u0001#I!\t\u0001\u0015*\u0003\u0002K\u0003\n!A+Z:u\u0011\u0015a\u0005\u0001\"\u0001G\u0003\u0001\"Xm\u001d;Ce>\\WM]!em\u0016\u0014H/[:f\u0019&\u001cH/\u001a8feN$vNW&\t\u000b9\u0003A\u0011\u0001$\u0002_Q,7\u000f\u001e\"s_.,'/\u00113wKJ$\u0018n]3MSN$XM\\3sg^KG\u000f[\"vgR|WNT1nKN$vNW&")
public class AdvertiseBrokerTest
extends JUnitSuite
implements ZooKeeperTestHarness {
    private final ArrayBuffer<KafkaServer> servers;
    private final int brokerId;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    @Override
    @Before
    public void setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AdvertiseBrokerTest advertiseBrokerTest = this;
        synchronized (advertiseBrokerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public ArrayBuffer<KafkaServer> servers() {
        return this.servers;
    }

    public int brokerId() {
        return this.brokerId;
    }

    @Override
    @After
    public void tearDown() {
        this.servers().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(KafkaServer s) {
                s.shutdown();
                CoreUtils$.MODULE$.delete(s.config().logDirs());
            }
        });
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Test
    public void testBrokerAdvertiseHostNameAndPortToZK() {
        String advertisedHostName = "routable-host1";
        int advertisedPort = 1234;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put("advertised.host.name", advertisedHostName);
        props.put("advertised.port", ((Object)BoxesRunTime.boxToInteger((int)advertisedPort)).toString());
        this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        Broker brokerInfo = (Broker)this.zkUtils().getBrokerInfo(this.brokerId()).get();
        Assert.assertEquals((long)1L, (long)brokerInfo.endPoints().size());
        EndPoint endpoint = (EndPoint)brokerInfo.endPoints().head();
        Assert.assertEquals((Object)advertisedHostName, (Object)endpoint.host());
        Assert.assertEquals((long)advertisedPort, (long)endpoint.port());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT.name, (Object)endpoint.listenerName().value());
    }

    public void testBrokerAdvertiseListenersToZK() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put("advertised.listeners", "PLAINTEXT://routable-listener:3334");
        this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        Broker brokerInfo = (Broker)this.zkUtils().getBrokerInfo(this.brokerId()).get();
        Assert.assertEquals((long)1L, (long)brokerInfo.endPoints().size());
        EndPoint endpoint = (EndPoint)brokerInfo.endPoints().head();
        Assert.assertEquals((Object)"routable-listener", (Object)endpoint.host());
        Assert.assertEquals((long)3334L, (long)endpoint.port());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT.name, (Object)endpoint.listenerName());
    }

    public void testBrokerAdvertiseListenersWithCustomNamesToZK() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(this.brokerId(), this.zkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put("listeners", "INTERNAL://:0,EXTERNAL://:0");
        props.put("advertised.listeners", "EXTERNAL://external-listener:9999,INTERNAL://internal-listener:10999");
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT,EXTERNAL:PLAINTEXT");
        props.put("inter.broker.listener.name", "INTERNAL");
        this.servers().$plus$eq((Object)TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(props), TestUtils$.MODULE$.createServer$default$2()));
        Broker brokerInfo = (Broker)this.zkUtils().getBrokerInfo(this.brokerId()).get();
        Assert.assertEquals((long)1L, (long)brokerInfo.endPoints().size());
        EndPoint endpoint = (EndPoint)brokerInfo.endPoints().head();
        Assert.assertEquals((Object)"external-listener", (Object)endpoint.host());
        Assert.assertEquals((long)9999L, (long)endpoint.port());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assert.assertEquals((Object)"EXTERNAL", (Object)endpoint.listenerName().value());
        EndPoint endpoint2 = (EndPoint)brokerInfo.endPoints().apply(1);
        Assert.assertEquals((Object)"internal-listener", (Object)endpoint2.host());
        Assert.assertEquals((long)10999L, (long)endpoint2.port());
        Assert.assertEquals((Object)SecurityProtocol.PLAINTEXT, (Object)endpoint.securityProtocol());
        Assert.assertEquals((Object)"INTERNAL", (Object)endpoint2.listenerName());
    }

    public AdvertiseBrokerTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        this.servers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.brokerId = 0;
    }
}

