/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.AbstractCreateTopicsRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.CreateTopicsRequest;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001-2A!\u0001\u0002\u0001\u000f\t92I]3bi\u0016$v\u000e]5dgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011q$\u00112tiJ\f7\r^\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$H+Z:u\u0011\u0015i\u0001\u0001\"\u0001\u000f\u0003\u0019a\u0014N\\5u}Q\tq\u0002\u0005\u0002\n\u0001!)\u0011\u0003\u0001C\u0001%\u0005iB/Z:u-\u0006d\u0017\u000eZ\"sK\u0006$X\rV8qS\u000e\u001c(+Z9vKN$8\u000fF\u0001\u0014!\t!r#D\u0001\u0016\u0015\u00051\u0012!B:dC2\f\u0017B\u0001\r\u0016\u0005\u0011)f.\u001b;)\u0005AQ\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0015QWO\\5u\u0015\u0005y\u0012aA8sO&\u0011\u0011\u0005\b\u0002\u0005)\u0016\u001cH\u000fC\u0003$\u0001\u0011\u0005!#A\u000fuKN$XI\u001d:pe\u000e\u0013X-\u0019;f)>\u0004\u0018nY:SKF,Xm\u001d;tQ\t\u0011#\u0004C\u0003'\u0001\u0011\u0005!#A\u0010uKN$\u0018J\u001c<bY&$7I]3bi\u0016$v\u000e]5dgJ+\u0017/^3tiND#!\n\u000e\t\u000b%\u0002A\u0011\u0001\n\u0002#Q,7\u000f\u001e(pi\u000e{g\u000e\u001e:pY2,'\u000f\u000b\u0002)5\u0001")
public class CreateTopicsRequestTest
extends AbstractCreateTopicsRequestTest {
    @Test
    public void testValidCreateTopicsRequests() {
        int timeout = 10000;
        this.validateValidCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), timeout).build());
        this.validateValidCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic2"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)3))}))).asJava(), timeout).build());
        java.util.Map config3 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}))).asJava();
        this.validateValidCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic3"), (Object)new CreateTopicsRequest.TopicDetails(5, (short)2, config3))}))).asJava(), timeout).build());
        java.util.Map<Integer, java.util.List<Integer>> assignments4 = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))));
        this.validateValidCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic4"), (Object)new CreateTopicsRequest.TopicDetails(assignments4))}))).asJava(), timeout).build());
        java.util.Map<Integer, java.util.List<Integer>> assignments5 = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}))));
        java.util.Map config5 = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"min.insync.replicas"), (Object)"2")}))).asJava();
        this.validateValidCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic5"), (Object)new CreateTopicsRequest.TopicDetails(assignments5, config5))}))).asJava(), timeout).build());
        java.util.Map<Integer, java.util.List<Integer>> assignments8 = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}))));
        this.validateValidCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic6"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic7"), (Object)new CreateTopicsRequest.TopicDetails(5, (short)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic8"), (Object)new CreateTopicsRequest.TopicDetails(assignments8))}))).asJava(), timeout).build());
        this.validateValidCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic9"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic10"), (Object)new CreateTopicsRequest.TopicDetails(5, (short)2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic11"), (Object)new CreateTopicsRequest.TopicDetails(assignments8))}))).asJava(), timeout, true).build());
    }

    @Test
    public void testErrorCreateTopicsRequests() {
        int timeout = 10000;
        String existingTopic = "existing-topic";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), existingTopic, 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), timeout).build(), (scala.collection.immutable.Map<String, CreateTopicsResponse.Error>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)this.error(Errors.TOPIC_ALREADY_EXISTS, (Option<String>)new Some((Object)"Topic 'existing-topic' already exists.")))}))), this.validateErrorCreateTopicsRequests$default$3());
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-partitions"), (Object)new CreateTopicsRequest.TopicDetails(-1, (short)1))}))).asJava(), timeout).build(), (scala.collection.immutable.Map<String, CreateTopicsResponse.Error>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-partitions"), (Object)this.error(Errors.INVALID_PARTITIONS, this.error$default$2()))}))), false);
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-replication"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)(this.numBrokers() + 1)))}))).asJava(), timeout).build(), (scala.collection.immutable.Map<String, CreateTopicsResponse.Error>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-replication"), (Object)this.error(Errors.INVALID_REPLICATION_FACTOR, this.error$default$2()))}))), false);
        java.util.Map invalidConfig = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"not.a.property"), (Object)"error")}))).asJava();
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-config"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1, invalidConfig))}))).asJava(), timeout).build(), (scala.collection.immutable.Map<String, CreateTopicsResponse.Error>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-config"), (Object)this.error(Errors.INVALID_CONFIG, this.error$default$2()))}))), false);
        java.util.Map<Integer, java.util.List<Integer>> invalidAssignments = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))));
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-assignment"), (Object)new CreateTopicsRequest.TopicDetails(invalidAssignments))}))).asJava(), timeout).build(), (scala.collection.immutable.Map<String, CreateTopicsResponse.Error>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-assignment"), (Object)this.error(Errors.INVALID_REPLICA_ASSIGNMENT, this.error$default$2()))}))), false);
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-partitions"), (Object)new CreateTopicsRequest.TopicDetails(-1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-replication"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)(this.numBrokers() + 1))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-assignment"), (Object)new CreateTopicsRequest.TopicDetails(invalidAssignments)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-none"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), timeout).build(), (scala.collection.immutable.Map<String, CreateTopicsResponse.Error>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)existingTopic), (Object)this.error(Errors.TOPIC_ALREADY_EXISTS, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-partitions"), (Object)this.error(Errors.INVALID_PARTITIONS, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-replication"), (Object)this.error(Errors.INVALID_REPLICATION_FACTOR, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-assignment"), (Object)this.error(Errors.INVALID_REPLICA_ASSIGNMENT, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partial-none"), (Object)this.error(Errors.NONE, this.error$default$2()))}))), false);
        this.validateTopicExists("partial-none");
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout"), (Object)new CreateTopicsRequest.TopicDetails(10, (short)3))}))).asJava(), 1).build(), (scala.collection.immutable.Map<String, CreateTopicsResponse.Error>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false);
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout-zero"), (Object)new CreateTopicsRequest.TopicDetails(10, (short)3))}))).asJava(), 0).build(), (scala.collection.immutable.Map<String, CreateTopicsResponse.Error>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout-zero"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false);
        this.validateErrorCreateTopicsRequests(new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout-negative"), (Object)new CreateTopicsRequest.TopicDetails(10, (short)3))}))).asJava(), -1).build(), (scala.collection.immutable.Map<String, CreateTopicsResponse.Error>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"error-timeout-negative"), (Object)this.error(Errors.REQUEST_TIMED_OUT, this.error$default$2()))}))), false);
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), "error-timeout", 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), "error-timeout-zero", 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), "error-timeout-negative", 0, TestUtils$.MODULE$.waitUntilMetadataIsPropagated$default$4());
        this.validateTopicExists("error-timeout");
        this.validateTopicExists("error-timeout-zero");
        this.validateTopicExists("error-timeout-negative");
    }

    @Test
    public void testInvalidCreateTopicsRequests() {
        CreateTopicsRequest singleRequest = new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicate-topic"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), 1000).build();
        CreateTopicsRequest duplicateRequest = this.duplicateFirstTopic(singleRequest);
        Assert.assertFalse((String)"Request doesn't have duplicate topics", (boolean)duplicateRequest.duplicateTopics().isEmpty());
        this.validateErrorCreateTopicsRequests(duplicateRequest, (scala.collection.immutable.Map<String, CreateTopicsResponse.Error>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicate-topic"), (Object)this.error(Errors.INVALID_REQUEST, (Option<String>)new Some((Object)"Create topics request from client `client-id` contains multiple entries for the following topics: duplicate-topic")))}))), this.validateErrorCreateTopicsRequests$default$3());
        CreateTopicsRequest doubleRequestValidateOnly = new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicate-topic"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-topic"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), 1000, true).build();
        CreateTopicsRequest duplicateDoubleRequestValidateOnly = this.duplicateFirstTopic(doubleRequestValidateOnly);
        Assert.assertFalse((String)"Request doesn't have duplicate topics", (boolean)duplicateDoubleRequestValidateOnly.duplicateTopics().isEmpty());
        this.validateErrorCreateTopicsRequests(duplicateDoubleRequestValidateOnly, (scala.collection.immutable.Map<String, CreateTopicsResponse.Error>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicate-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-topic"), (Object)this.error(Errors.NONE, this.error$default$2()))}))), false);
        CreateTopicsRequest doubleRequest = new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicate-topic"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-topic"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), 1000).build();
        CreateTopicsRequest duplicateDoubleRequest = this.duplicateFirstTopic(doubleRequest);
        Assert.assertFalse((String)"Request doesn't have duplicate topics", (boolean)duplicateDoubleRequest.duplicateTopics().isEmpty());
        this.validateErrorCreateTopicsRequests(duplicateDoubleRequest, (scala.collection.immutable.Map<String, CreateTopicsResponse.Error>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"duplicate-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"other-topic"), (Object)this.error(Errors.NONE, this.error$default$2()))}))), false);
        java.util.Map<Integer, java.util.List<Integer>> assignments = this.replicaAssignmentToJava((scala.collection.immutable.Map<Object, List<Object>>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))));
        CreateTopicsRequest assignmentRequest = new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)new CreateTopicsRequest.TopicDetails(assignments))}))).asJava(), 1000).build();
        CreateTopicsRequest badArgumentsRequest = this.addPartitionsAndReplicationFactorToFirstTopic(assignmentRequest);
        this.validateErrorCreateTopicsRequests(badArgumentsRequest, (scala.collection.immutable.Map<String, CreateTopicsResponse.Error>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false);
        CreateTopicsRequest assignmentRequestValidateOnly = new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)new CreateTopicsRequest.TopicDetails(assignments))}))).asJava(), 1000, true).build();
        CreateTopicsRequest badArgumentsRequestValidateOnly = this.addPartitionsAndReplicationFactorToFirstTopic(assignmentRequestValidateOnly);
        this.validateErrorCreateTopicsRequests(badArgumentsRequestValidateOnly, (scala.collection.immutable.Map<String, CreateTopicsResponse.Error>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bad-args-topic"), (Object)this.error(Errors.INVALID_REQUEST, this.error$default$2()))}))), false);
    }

    @Test
    public void testNotController() {
        CreateTopicsRequest request = new CreateTopicsRequest.Builder((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"topic1"), (Object)new CreateTopicsRequest.TopicDetails(1, (short)1))}))).asJava(), 1000).build();
        CreateTopicsResponse response = this.sendCreateTopicRequest(request, this.notControllerSocketServer());
        Errors error = ((CreateTopicsResponse.Error)((Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errors()).asScala()).head())._2()).error();
        Assert.assertEquals((String)"Expected controller error when routed incorrectly", (Object)Errors.NOT_CONTROLLER, (Object)error);
    }
}

