/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaQuota;
import kafka.utils.KafkaScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ue\u0001B\u0001\u0003\u0001\u001d\u0011\u0001DU3qY&\u001c\u0017-T1oC\u001e,'/U;pi\u0006\u001cH+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003\u001d\u0019wN\u001c4jON,\u0012A\u0006\t\u0004/iaR\"\u0001\r\u000b\u0005eQ\u0011AC2pY2,7\r^5p]&\u00111\u0004\u0007\u0002\u0004'\u0016\f\bC\u0001\n\u001e\u0013\tq\"AA\u0006LC\u001a\\\u0017mQ8oM&<\u0007B\u0002\u0011\u0001A\u0003%a#\u0001\u0005d_:4\u0017nZ:!\u0011\u001d\u0011\u0003A1A\u0005\u0002\r\nA\u0001^5nKV\tA\u0005\u0005\u0002&Q5\taE\u0003\u0002(\t\u0005)Q\u000f^5mg&\u0011\u0011F\n\u0002\t\u001b>\u001c7\u000eV5nK\"11\u0006\u0001Q\u0001\n\u0011\nQ\u0001^5nK\u0002Bq!\f\u0001C\u0002\u0013\u0005a&A\u0004nKR\u0014\u0018nY:\u0016\u0003=\u0002\"\u0001M\u001d\u000e\u0003ER!!\f\u001a\u000b\u0005M\"\u0014AB2p[6|gN\u0003\u0002\u0006k)\u0011agN\u0001\u0007CB\f7\r[3\u000b\u0003a\n1a\u001c:h\u0013\tQ\u0014GA\u0004NKR\u0014\u0018nY:\t\rq\u0002\u0001\u0015!\u00030\u0003!iW\r\u001e:jGN\u0004\u0003b\u0002 \u0001\u0005\u0004%\taP\u0001\u0007e\u0016\u001cwN\u001d3\u0016\u0003\u0001\u0003\"!Q\"\u000e\u0003\tS!A\u0010\u001a\n\u0005\u0011\u0013%A\u0002*fG>\u0014H\r\u0003\u0004G\u0001\u0001\u0006I\u0001Q\u0001\be\u0016\u001cwN\u001d3!\u0011\u001dA\u0005A1A\u0005\u0002%\u000bq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g.M\u000b\u0002\u0015B\u00111\nT\u0007\u0002e%\u0011QJ\r\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019y\u0005\u0001)A\u0005\u0015\u0006\u0001Bo\u001c9jGB\u000b'\u000f^5uS>t\u0017\u0007\t\u0005\b#\u0002\u0011\r\u0011\"\u0001J\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0014\u0004BB*\u0001A\u0003%!*\u0001\tu_BL7\rU1si&$\u0018n\u001c83A!9Q\u000b\u0001b\u0001\n\u00031\u0016!\u00034fi\u000eD\u0017J\u001c4p+\u00059\u0006cA\f\u001b1B!\u0011\"\u0017&\\\u0013\tQ&B\u0001\u0004UkBdWM\r\t\u00039:t!!X6\u000f\u0005yKgBA0i\u001d\t\u0001wM\u0004\u0002bM:\u0011!-Z\u0007\u0002G*\u0011AMB\u0001\u0007yI|w\u000e\u001e \n\u0003aJ!AN\u001c\n\u0005\u0015)\u0014BA\u001a5\u0013\tQ''\u0001\u0005sKF,Xm\u001d;t\u0013\taW.\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cHO\u0003\u0002ke%\u0011q\u000e\u001d\u0002\u000e!\u0006\u0014H/\u001b;j_:$\u0015\r^1\u000b\u00051l\u0007B\u0002:\u0001A\u0003%q+\u0001\u0006gKR\u001c\u0007.\u00138g_\u0002Bq\u0001\u001e\u0001A\u0002\u0013\u0005Q/\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0003Y\u0004\"AE<\n\u0005a\u0014!A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\bu\u0002\u0001\r\u0011\"\u0001|\u0003I\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ|F%Z9\u0015\u0005q|\bCA\u0005~\u0013\tq(B\u0001\u0003V]&$\b\u0002CA\u0001s\u0006\u0005\t\u0019\u0001<\u0002\u0007a$\u0013\u0007C\u0004\u0002\u0006\u0001\u0001\u000b\u0015\u0002<\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002Bq!!\u0003\u0001\t\u0003\tY!\u0001\u0016tQ>,H\u000eZ#yG2,H-Z*vEN,\u0017/^3oiRC'o\u001c;uY\u0016$\u0007+\u0019:uSRLwN\\:\u0015\u0003qDC!a\u0002\u0002\u0010A!\u0011\u0011CA\f\u001b\t\t\u0019BC\u0002\u0002\u0016]\nQA[;oSRLA!!\u0007\u0002\u0014\t!A+Z:u\u0011\u001d\ti\u0002\u0001C\u0001\u0003\u0017\t\u0011h\u001d5pk2$w)\u001a;O_6+7o]1hKNLe-U;pi\u0006\u001cX\t_2fK\u0012,Gm\u00148Tk\n\u001cX-];f]R\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0005\u00037\ty\u0001C\u0004\u0002$\u0001!\t!a\u0003\u0002EMDw.\u001e7e\u000f\u0016$(i\u001c;i\u001b\u0016\u001c8/Y4fg&3\u0017+^8uCN\fE\u000e\\8xQ\u0011\t\t#a\u0004\t\u000f\u0005%\u0002\u0001\"\u0001\u0002\f\u0005!3\u000f[8vY\u0012Len\u00197vI\u0016LenU=oGRC'o\u001c;uY\u0016$'+\u001a9mS\u000e\f7\u000f\u000b\u0003\u0002(\u0005=\u0001bBA\u0018\u0001\u0011\u0005\u0011\u0011G\u0001\u000bg\u0016$X\u000b]'pG.\u001cHc\u0002?\u00024\u0005\u0015\u0013q\t\u0005\b+\u00065\u0002\u0019AA\u001b!\u0015\t9$!\u0011Y\u001d\u0011\tI$!\u0010\u000f\u0007\t\fY$C\u0001\f\u0013\r\tyDC\u0001\ba\u0006\u001c7.Y4f\u0013\rY\u00121\t\u0006\u0004\u0003\u007fQ\u0001\u0002\u0003 \u0002.A\u0005\t\u0019\u0001!\t\u0015\u0005%\u0013Q\u0006I\u0001\u0002\u0004\tY%\u0001\nc_RD'+\u001a9mS\u000e\f7/\u00138Ts:\u001c\u0007cA\u0005\u0002N%\u0019\u0011q\n\u0006\u0003\u000f\t{w\u000e\\3b]\"9\u00111\u000b\u0001\u0005\u0002\u0005-\u0011\u0001\u0003;fCJ$un\u001e8)\t\u0005E\u0013q\u000b\t\u0005\u0003#\tI&\u0003\u0003\u0002\\\u0005M!!B!gi\u0016\u0014\bbBA0\u0001\u0011\u0005\u0011\u0011M\u0001\n[>\u001c7.U;pi\u0006$B!a\u0019\u0002jA\u0019!#!\u001a\n\u0007\u0005\u001d$A\u0001\u0007SKBd\u0017nY1Rk>$\u0018\r\u0003\u0005\u0002l\u0005u\u0003\u0019AA7\u0003\u0015\u0011w.\u001e8e!\rI\u0011qN\u0005\u0004\u0003cR!\u0001\u0002'p]\u001eD\u0011\"!\u001e\u0001#\u0003%\t!a\u001e\u0002)M,G/\u00169N_\u000e\\7\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tIHK\u0002A\u0003wZ#!! \u0011\t\u0005}\u0014\u0011R\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000fS\u0011AC1o]>$\u0018\r^5p]&!\u00111RAA\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003\u001f\u0003\u0011\u0013!C\u0001\u0003#\u000bAc]3u+BlunY6tI\u0011,g-Y;mi\u0012\u001aTCAAJU\u0011\tY%a\u001f")
public class ReplicaManagerQuotasTest {
    private final Seq<KafkaConfig> configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12()).map((Function1)new Serializable(this){
        public static final long serialVersionUID = 0L;

        public final KafkaConfig apply(Properties x$1) {
            return KafkaConfig$.MODULE$.fromProps(x$1, new Properties());
        }
    }, Seq$.MODULE$.canBuildFrom());
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private final Record record = Record.create((byte[])"some-data-in-a-message".getBytes());
    private final TopicPartition topicPartition1 = new TopicPartition("test-topic", 1);
    private final TopicPartition topicPartition2 = new TopicPartition("test-topic", 2);
    private final Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition1()), (Object)new FetchRequest.PartitionData(0L, 100)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.topicPartition2()), (Object)new FetchRequest.PartitionData(0L, 100))}));
    private ReplicaManager replicaManager = null;

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public Record record() {
        return this.record;
    }

    public TopicPartition topicPartition1() {
        return this.topicPartition1;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo() {
        return this.fetchInfo;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Test
    public void shouldExcludeSubsequentThrottledPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota);
        Assert.assertEquals((String)"Given two partitions, with only one throttled, we should get the first", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$2) {
                Object object = x$2._1();
                TopicPartition topicPartition = this.$outer.topicPartition1();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().shallowEntries()).asScala()).size());
        Assert.assertEquals((String)"But we shouldn't get the second", (long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$3) {
                Object object = x$3._1();
                TopicPartition topicPartition = this.$outer.topicPartition2();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().shallowEntries()).asScala()).size());
    }

    @Test
    public void shouldGetNoMessagesIfQuotasExceededOnSubsequentPartitions() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota);
        Assert.assertEquals((String)"Given two partitions, with both throttled, we should get no messages", (long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$4) {
                Object object = x$4._1();
                TopicPartition topicPartition = this.$outer.topicPartition1();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().shallowEntries()).asScala()).size());
        Assert.assertEquals((String)"Given two partitions, with both throttled, we should get no messages", (long)0L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$5) {
                Object object = x$5._1();
                TopicPartition topicPartition = this.$outer.topicPartition2();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().shallowEntries()).asScala()).size());
    }

    @Test
    public void shouldGetBothMessagesIfQuotasAllow() {
        this.setUpMocks(this.fetchInfo(), this.setUpMocks$default$2(), this.setUpMocks$default$3());
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota);
        Assert.assertEquals((String)"Given two partitions, with both non-throttled, we should get both messages", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$6) {
                Object object = x$6._1();
                TopicPartition topicPartition = this.$outer.topicPartition1();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().shallowEntries()).asScala()).size());
        Assert.assertEquals((String)"Given two partitions, with both non-throttled, we should get both messages", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$7) {
                Object object = x$7._1();
                TopicPartition topicPartition = this.$outer.topicPartition2();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().shallowEntries()).asScala()).size());
    }

    @Test
    public void shouldIncludeInSyncThrottledReplicas() {
        Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> x$11 = this.fetchInfo();
        boolean x$12 = true;
        Record x$13 = this.setUpMocks$default$2();
        this.setUpMocks(x$11, x$13, x$12);
        int followerReplicaId = ((KafkaConfig)this.configs().last()).brokerId();
        ReplicaQuota quota = this.mockQuota(1000000L);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)false)).once();
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isQuotaExceeded())).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).once();
        EasyMock.replay((Object[])new Object[]{quota});
        Seq fetch2 = this.replicaManager().readFromLocalLog(followerReplicaId, true, true, Integer.MAX_VALUE, false, this.fetchInfo(), quota);
        Assert.assertEquals((String)"Given two partitions, with only one throttled, we should get the first", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$8) {
                Object object = x$8._1();
                TopicPartition topicPartition = this.$outer.topicPartition1();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().shallowEntries()).asScala()).size());
        Assert.assertEquals((String)"But we should get the second too since it's throttled but in sync", (long)1L, (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(((LogReadResult)((Tuple2)fetch2.find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;

            public final boolean apply(Tuple2<TopicPartition, LogReadResult> x$9) {
                Object object = x$9._1();
                TopicPartition topicPartition = this.$outer.topicPartition2();
                return !(object != null ? !object.equals(topicPartition) : topicPartition != null);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).get())._2()).info().records().shallowEntries()).asScala()).size());
    }

    public void setUpMocks(Seq<Tuple2<TopicPartition, FetchRequest.PartitionData>> fetchInfo, Record record, boolean bothReplicasInSync) {
        ZkUtils zkUtils = (ZkUtils)EasyMock.createNiceMock(ZkUtils.class);
        KafkaScheduler scheduler = (KafkaScheduler)EasyMock.createNiceMock(KafkaScheduler.class);
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())).andReturn((Object)BoxesRunTime.boxToLong((long)20L)).anyTimes();
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata(20L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3())).anyTimes();
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.geq((int)1), (Option)EasyMock.anyObject(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.withRecords((Record[])new Record[]{record}), FetchDataInfo$.MODULE$.apply$default$3())).anyTimes();
        EasyMock.expect((Object)log.read(BoxesRunTime.unboxToLong((Object)EasyMock.anyObject()), EasyMock.eq((int)0), (Option)EasyMock.anyObject(), BoxesRunTime.unboxToBoolean((Object)EasyMock.anyObject()))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(0L, 0L, 0), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.getLog((TopicPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)log)).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), zkUtils, (Scheduler)scheduler, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time()).follower(), ReplicaManager$.MODULE$.$lessinit$greater$default$9()));
        fetchInfo.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, FetchRequest.PartitionData> check$ifrefutable$1) {
                Tuple2<TopicPartition, FetchRequest.PartitionData> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).foreach((Function1)new Serializable(this, bothReplicasInSync, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ReplicaManagerQuotasTest $outer;
            private final boolean bothReplicasInSync$1;
            private final Log log$1;

            public final void apply(Tuple2<TopicPartition, FetchRequest.PartitionData> x$10) {
                Tuple2<TopicPartition, FetchRequest.PartitionData> tuple2 = x$10;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    TopicPartition p = (TopicPartition)tuple2._1();
                    Partition partition = this.$outer.replicaManager().getOrCreatePartition(p);
                    Replica leaderReplica = new Replica(((KafkaConfig)this.$outer.configs().head()).brokerId(), partition, (Time)this.$outer.time(), 0L, (Option)new Some((Object)this.log$1));
                    leaderReplica.highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
                    partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderReplica.brokerId())));
                    Replica followerReplica = new Replica(((KafkaConfig)this.$outer.configs().last()).brokerId(), partition, (Time)this.$outer.time(), 0L, (Option)new Some((Object)this.log$1));
                    Set allReplicas = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Replica[]{leaderReplica, followerReplica}));
                    allReplicas.foreach((Function1)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final Partition partition$1;

                        public final Replica apply(Replica replica) {
                            return this.partition$1.addReplicaIfNotExists(replica);
                        }
                        {
                            this.partition$1 = partition$1;
                        }
                    });
                    if (this.bothReplicasInSync$1) {
                        partition.inSyncReplicas_$eq(allReplicas);
                        followerReplica.highWatermark_$eq(new LogOffsetMetadata(5L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        partition.inSyncReplicas_$eq((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Replica[]{leaderReplica})));
                        followerReplica.highWatermark_$eq(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()));
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.bothReplicasInSync$1 = bothReplicasInSync$1;
                this.log$1 = log$1;
            }
        });
    }

    public Record setUpMocks$default$2() {
        return this.record();
    }

    public boolean setUpMocks$default$3() {
        return false;
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    public ReplicaQuota mockQuota(long bound) {
        void var3_2;
        ReplicaQuota quota = (ReplicaQuota)EasyMock.createMock(ReplicaQuota.class);
        EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)quota.isThrottled((TopicPartition)EasyMock.anyObject()))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
        return var3_2;
    }
}

