/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.log.LogManager;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaManagerTest$;
import kafka.server.ReplicaQuota;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.PartitionState;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0001\u000f\t\u0011\"+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014H+Z:u\u0015\t\u0019A!\u0001\u0004tKJ4XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\b)\u0001\u0011\r\u0011\"\u0001\u0016\u0003\u0015!x\u000e]5d+\u00051\u0002CA\f\u001d\u001b\u0005A\"BA\r\u001b\u0003\u0011a\u0017M\\4\u000b\u0003m\tAA[1wC&\u0011Q\u0004\u0007\u0002\u0007'R\u0014\u0018N\\4\t\r}\u0001\u0001\u0015!\u0003\u0017\u0003\u0019!x\u000e]5dA!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0013\u0001\u0002;j[\u0016,\u0012a\t\t\u0003I\u001dj\u0011!\n\u0006\u0003M\u0011\tQ!\u001e;jYNL!\u0001K\u0013\u0003\u00115{7m\u001b+j[\u0016DaA\u000b\u0001!\u0002\u0013\u0019\u0013!\u0002;j[\u0016\u0004\u0003b\u0002\u0017\u0001\u0005\u0004%\t!L\u0001\b[\u0016$(/[2t+\u0005q\u0003CA\u00189\u001b\u0005\u0001$B\u0001\u00172\u0015\t\u00114'\u0001\u0004d_6lwN\u001c\u0006\u0003\u000bQR!!\u000e\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0014aA8sO&\u0011\u0011\b\r\u0002\b\u001b\u0016$(/[2t\u0011\u0019Y\u0004\u0001)A\u0005]\u0005AQ.\u001a;sS\u000e\u001c\b\u0005C\u0005>\u0001\u0001\u0007\t\u0019!C\u0001}\u0005A!p[\"mS\u0016tG/F\u0001@!\t\u0001U)D\u0001B\u0015\t\u00115)\u0001\u0005{W\u000ed\u0017.\u001a8u\u0015\t!e'\u0001\u0004Ja%#XmY\u0005\u0003\r\u0006\u0013\u0001BW6DY&,g\u000e\u001e\u0005\n\u0011\u0002\u0001\r\u00111A\u0005\u0002%\u000bAB_6DY&,g\u000e^0%KF$\"AS'\u0011\u0005%Y\u0015B\u0001'\u000b\u0005\u0011)f.\u001b;\t\u000f9;\u0015\u0011!a\u0001\u007f\u0005\u0019\u0001\u0010J\u0019\t\rA\u0003\u0001\u0015)\u0003@\u0003%Q8n\u00117jK:$\b\u0005C\u0005S\u0001\u0001\u0007\t\u0019!C\u0001'\u00069!p[+uS2\u001cX#\u0001+\u0011\u0005\u0011*\u0016B\u0001,&\u0005\u001dQ6.\u0016;jYND\u0011\u0002\u0017\u0001A\u0002\u0003\u0007I\u0011A-\u0002\u0017i\\W\u000b^5mg~#S-\u001d\u000b\u0003\u0015jCqAT,\u0002\u0002\u0003\u0007A\u000b\u0003\u0004]\u0001\u0001\u0006K\u0001V\u0001\tu.,F/\u001b7tA!)a\f\u0001C\u0001?\u0006)1/\u001a;VaR\t!\n\u000b\u0002^CB\u0011!-Z\u0007\u0002G*\u0011AMN\u0001\u0006UVt\u0017\u000e^\u0005\u0003M\u000e\u0014aAQ3g_J,\u0007\"\u00025\u0001\t\u0003y\u0016\u0001\u0003;fCJ$un\u001e8)\u0005\u001dT\u0007C\u00012l\u0013\ta7MA\u0003BMR,'\u000fC\u0003o\u0001\u0011\u0005q,A\u0011uKN$\b*[4i/\u0006$XM]'be.$\u0015N]3di>\u0014\u00180T1qa&tw\r\u000b\u0002naB\u0011!-]\u0005\u0003e\u000e\u0014A\u0001V3ti\")A\u000f\u0001C\u0001?\u0006IC/Z:u\u0011&<\u0007n^1uKJl\u0015M]6SK2\fG/\u001b<f\t&\u0014Xm\u0019;pefl\u0015\r\u001d9j]\u001eD#a\u001d9\t\u000b]\u0004A\u0011A0\u0002/Q,7\u000f^%mY\u0016<\u0017\r\u001c*fcVL'/\u001a3BG.\u001c\bF\u0001<q\u0011\u0015Q\b\u0001\"\u0001`\u0003\u0011\"Xm\u001d;DY\u0016\f'\u000fU;sO\u0006$xN]=P]\n+7m\\7j]\u001e4u\u000e\u001c7po\u0016\u0014\bFA=q\u0011\u0015i\b\u0001\"\u0001`\u0003=\"Xm\u001d;GKR\u001c\u0007NQ3z_:$\u0007*[4i/\u0006$XM]7be.\u0014V\r^;s]\u0016k\u0007\u000f^=SKN\u0004xN\\:fQ\ta\b\u000f")
public class ReplicaManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private ZkClient zkClient;
    private ZkUtils zkUtils;

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Before
    public void setUp() {
        this.zkClient_$eq((ZkClient)EasyMock.createMock(ZkClient.class));
        this.zkUtils_$eq(ZkUtils$.MODULE$.apply(this.zkClient(), false));
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$1) {
                return new File(x$1);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time()).follower(), ReplicaManager$.MODULE$.$lessinit$greater$default$9());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1);
            rm.checkpointHighWatermarks();
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$2) {
                return new File(x$2);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time()).follower(), ReplicaManager$.MODULE$.$lessinit$greater$default$9());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1);
            rm.checkpointHighWatermarks();
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testIllegalRequiredAcks() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$3) {
                return new File(x$3);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time()).follower(), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            rm.appendRecords(0L, (short)3, false, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0)), (Object)MemoryRecords.withRecords((Record[])new Record[]{Record.create((byte[])"first message".getBytes())}))})), (Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;

                public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$callback$1(responseStatus);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testClearPurgatoryOnBecomingFollower() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$4) {
                return new File(x$4);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time()).follower(), ReplicaManager$.MODULE$.$lessinit$greater$default$9());
        try {
            BooleanRef produceCallbackFired = BooleanRef.create((boolean)false);
            BooleanRef fetchCallbackFired = BooleanRef.create((boolean)false);
            Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
            MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
            EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
            EasyMock.replay((Object[])new Object[]{metadataCache});
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            java.util.Set brokerSet = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0);
            LeaderAndIsrRequest leaderAndIsrRequest1 = new LeaderAndIsrRequest.Builder(0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new PartitionState(0, 0, 0, brokerList, 0, brokerSet))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, metadataCache, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$6, Iterable<Partition> x$7) {
                }
            });
            rm.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            rm.appendRecords(1000L, (short)-1, false, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)MemoryRecords.withRecords((Record[])new Record[]{Record.create((byte[])"first message".getBytes())}))})), (Function1)new Serializable(this, produceCallbackFired){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final BooleanRef produceCallbackFired$1;

                public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$produceCallback$1(responseStatus, this.produceCallbackFired$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.produceCallbackFired$1 = produceCallbackFired$1;
                }
            });
            long x$15 = 1000L;
            int x$16 = -1;
            int x$17 = 100000;
            int x$18 = Integer.MAX_VALUE;
            boolean x$19 = false;
            Seq x$20 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new FetchRequest.PartitionData(0L, 100000))}));
            Serializable x$21 = new Serializable(this, fetchCallbackFired){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final BooleanRef fetchCallbackFired$1;

                public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$fetchCallback$1(responseStatus, this.fetchCallbackFired$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fetchCallbackFired$1 = fetchCallbackFired$1;
                }
            };
            ReplicaQuota x$22 = rm.fetchMessages$default$7();
            rm.fetchMessages(x$15, x$16, x$17, x$18, x$19, x$20, x$22, (Function1)x$21);
            LeaderAndIsrRequest leaderAndIsrRequest2 = new LeaderAndIsrRequest.Builder(0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new PartitionState(0, 1, 1, brokerList, 0, brokerSet))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(1, leaderAndIsrRequest2, metadataCache, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$8, Iterable<Partition> x$9) {
                }
            });
            Assert.assertTrue((boolean)produceCallbackFired.elem);
            Assert.assertTrue((boolean)fetchCallbackFired.elem);
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testFetchBeyondHighWatermarkReturnEmptyResponse() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        props.put("broker.id", BoxesRunTime.boxToInteger((int)0));
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((File[])((TraversableOnce)config.logDirs().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(String x$10) {
                return new File(x$10);
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(File.class)), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.zkUtils(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time()).follower(), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host2", 2, TestUtils$.MODULE$.createBroker$default$4())}));
            MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
            EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
            EasyMock.replay((Object[])new Object[]{metadataCache});
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
            java.util.Set brokerSet = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0);
            LeaderAndIsrRequest leaderAndIsrRequest1 = new LeaderAndIsrRequest.Builder(0, 0, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new PartitionState(0, 0, 0, brokerList, 0, brokerSet))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1), new Node(2, "host2", 2)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, metadataCache, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Iterable<Partition> x$11, Iterable<Partition> x$12) {
                }
            });
            rm.getLeaderReplicaIfLocal(new TopicPartition(this.topic(), 0));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach$mVc$sp((Function1)new Serializable(this, rm){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final ReplicaManager rm$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.rm$1.appendRecords(1000L, (short)-1, false, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.$outer.topic(), 0)), (Object)MemoryRecords.withRecords((Record[])new Record[]{Record.create((byte[])new StringOps(Predef$.MODULE$.augmentString("message %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i)})).getBytes())}))})), (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$1 $outer;

                        public final void apply(Map<TopicPartition, ProduceResponse.PartitionResponse> responseStatus) {
                            this.$outer.kafka$server$ReplicaManagerTest$$anonfun$$$outer().kafka$server$ReplicaManagerTest$$produceCallback$2(responseStatus);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                }

                public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.rm$1 = rm$1;
                }
            });
            BooleanRef fetchCallbackFired = BooleanRef.create((boolean)false);
            IntRef fetchError = IntRef.create((int)0);
            ObjectRef fetchedRecords = ObjectRef.create(null);
            long x$23 = 1000L;
            int x$24 = 1;
            int x$25 = 0;
            int x$26 = Integer.MAX_VALUE;
            boolean x$27 = false;
            Seq x$28 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new FetchRequest.PartitionData(1L, 100000))}));
            Serializable x$29 = new Serializable(this, fetchCallbackFired, fetchError, fetchedRecords){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final BooleanRef fetchCallbackFired$2;
                private final IntRef fetchError$1;
                private final ObjectRef fetchedRecords$1;

                public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$fetchCallback$2(responseStatus, this.fetchCallbackFired$2, this.fetchError$1, this.fetchedRecords$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fetchCallbackFired$2 = fetchCallbackFired$2;
                    this.fetchError$1 = fetchError$1;
                    this.fetchedRecords$1 = fetchedRecords$1;
                }
            };
            ReplicaQuota x$30 = rm.fetchMessages$default$7();
            rm.fetchMessages(x$23, x$24, x$25, x$26, x$27, x$28, x$30, (Function1)x$29);
            Assert.assertTrue((boolean)fetchCallbackFired.elem);
            Assert.assertEquals((String)"Should not give an exception", (long)Errors.NONE.code(), (long)fetchError.elem);
            Assert.assertTrue((String)"Should return some data", (boolean)((Records)fetchedRecords.elem).shallowEntries().iterator().hasNext());
            fetchCallbackFired.elem = false;
            long x$31 = 1000L;
            int x$32 = -1;
            int x$33 = 0;
            int x$34 = Integer.MAX_VALUE;
            boolean x$35 = false;
            Seq x$36 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new FetchRequest.PartitionData(1L, 100000))}));
            Serializable x$37 = new Serializable(this, fetchCallbackFired, fetchError, fetchedRecords){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ReplicaManagerTest $outer;
                private final BooleanRef fetchCallbackFired$2;
                private final IntRef fetchError$1;
                private final ObjectRef fetchedRecords$1;

                public final void apply(Seq<Tuple2<TopicPartition, FetchPartitionData>> responseStatus) {
                    this.$outer.kafka$server$ReplicaManagerTest$$fetchCallback$2(responseStatus, this.fetchCallbackFired$2, this.fetchError$1, this.fetchedRecords$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.fetchCallbackFired$2 = fetchCallbackFired$2;
                    this.fetchError$1 = fetchError$1;
                    this.fetchedRecords$1 = fetchedRecords$1;
                }
            };
            ReplicaQuota x$38 = rm.fetchMessages$default$7();
            rm.fetchMessages(x$31, x$32, x$33, x$34, x$35, x$36, x$38, (Function1)x$37);
            Assert.assertTrue((boolean)fetchCallbackFired.elem);
            Assert.assertEquals((String)"Should not give an exception", (long)Errors.NONE.code(), (long)fetchError.elem);
            Assert.assertEquals((String)"Should return empty response", (Object)MemoryRecords.EMPTY, (Object)((Records)fetchedRecords.elem));
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.shutdown(false);
            throw throwable;
        }
        rm.shutdown(false);
    }

    public final void kafka$server$ReplicaManagerTest$$callback$1(Map responseStatus) {
        Errors errors = ((ProduceResponse.PartitionResponse)responseStatus.values().head()).error;
        Errors errors2 = Errors.INVALID_REQUIRED_ACKS;
        Predef$.MODULE$.assert(!(errors != null ? !errors.equals(errors2) : errors2 != null));
    }

    public final void kafka$server$ReplicaManagerTest$$produceCallback$1(Map responseStatus, BooleanRef produceCallbackFired$1) {
        Assert.assertEquals((String)"Should give NotLeaderForPartitionException", (Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)((ProduceResponse.PartitionResponse)responseStatus.values().head()).error);
        produceCallbackFired$1.elem = true;
    }

    public final void kafka$server$ReplicaManagerTest$$fetchCallback$1(Seq responseStatus, BooleanRef fetchCallbackFired$1) {
        Assert.assertEquals((String)"Should give NotLeaderForPartitionException", (Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)((FetchPartitionData)((IterableLike)responseStatus.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FetchPartitionData apply(Tuple2<TopicPartition, FetchPartitionData> x$5) {
                return (FetchPartitionData)x$5._2();
            }
        }, Seq$.MODULE$.canBuildFrom())).head()).error());
        fetchCallbackFired$1.elem = true;
    }

    public final void kafka$server$ReplicaManagerTest$$produceCallback$2(Map responseStatus) {
    }

    public final void kafka$server$ReplicaManagerTest$$fetchCallback$2(Seq responseStatus, BooleanRef fetchCallbackFired$2, IntRef fetchError$1, ObjectRef fetchedRecords$1) {
        fetchError$1.elem = ((FetchPartitionData)((IterableLike)responseStatus.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FetchPartitionData apply(Tuple2<TopicPartition, FetchPartitionData> x$13) {
                return (FetchPartitionData)x$13._2();
            }
        }, Seq$.MODULE$.canBuildFrom())).head()).error().code();
        fetchedRecords$1.elem = ((FetchPartitionData)((IterableLike)responseStatus.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final FetchPartitionData apply(Tuple2<TopicPartition, FetchPartitionData> x$14) {
                return (FetchPartitionData)x$14._2();
            }
        }, Seq$.MODULE$.canBuildFrom())).head()).records();
        fetchCallbackFired$2.elem = true;
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
    }
}

